/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee9.nested;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.nio.file.Path;
import java.time.Duration;
import java.util.List;
import org.eclipse.jetty.ee9.nested.ContextHandler;
import org.eclipse.jetty.ee9.nested.HandlerWrapper;
import org.eclipse.jetty.ee9.nested.Request;
import org.eclipse.jetty.ee9.nested.ResourceService;
import org.eclipse.jetty.http.CompressedContentFormat;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.http.PreEncodedHttpField;
import org.eclipse.jetty.http.content.FileMappingHttpContentFactory;
import org.eclipse.jetty.http.content.HttpContent;
import org.eclipse.jetty.http.content.PreCompressedHttpContentFactory;
import org.eclipse.jetty.http.content.ResourceHttpContentFactory;
import org.eclipse.jetty.http.content.ValidatingCachingHttpContentFactory;
import org.eclipse.jetty.http.content.VirtualHttpContentFactory;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceHandler
extends HandlerWrapper
implements ResourceService.WelcomeFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceHandler.class);
    private ByteBufferPool.Sized _byteBufferPool;
    private int _byteBufferSize = 32768;
    private boolean _useDirectByteBuffers = true;
    Resource _baseResource;
    ContextHandler _context;
    Resource _defaultStyleSheet;
    MimeTypes _mimeTypes;
    private final ResourceService _resourceService;
    Resource _styleSheet;
    String[] _welcomes = new String[]{"index.html"};

    public ResourceHandler(ResourceService resourceService) {
        this._resourceService = resourceService;
    }

    public ResourceHandler() {
        this(new ResourceService(){

            @Override
            protected void notFound(HttpServletRequest request, HttpServletResponse response) throws IOException {
            }
        });
        this._resourceService.setGzipEquivalentFileExtensions(List.of(".svgz"));
    }

    @Override
    public String getWelcomeFile(String pathInContext) {
        if (this._welcomes == null) {
            return null;
        }
        for (String s : this._welcomes) {
            String welcomeInContext = URIUtil.addPaths(pathInContext, s);
            Resource welcome = this._baseResource.resolve(welcomeInContext);
            if (!welcome.exists()) continue;
            return welcomeInContext;
        }
        return null;
    }

    @Override
    public void doStart() throws Exception {
        ContextHandler.APIContext scontext = ContextHandler.getCurrentContext();
        ContextHandler contextHandler = this._context = scontext == null ? null : scontext.getContextHandler();
        if (this._mimeTypes == null) {
            this._mimeTypes = this._context == null ? MimeTypes.DEFAULTS : this._context.getMimeTypes();
        }
        this._byteBufferPool = new ByteBufferPool.Sized(ResourceHandler.getByteBufferPool(this._context), this._useDirectByteBuffers, this._byteBufferSize);
        if (this._resourceService.getHttpContentFactory() == null) {
            this._resourceService.setHttpContentFactory(this.newHttpContentFactory());
        }
        this._resourceService.setWelcomeFactory(this);
        super.doStart();
    }

    private static ByteBufferPool getByteBufferPool(ContextHandler contextHandler) {
        if (contextHandler == null) {
            return ByteBufferPool.NON_POOLING;
        }
        Server server = contextHandler.getServer();
        if (server == null) {
            return ByteBufferPool.NON_POOLING;
        }
        return server.getByteBufferPool();
    }

    public HttpContent.Factory getHttpContentFactory() {
        return this._resourceService.getHttpContentFactory();
    }

    protected HttpContent.Factory newHttpContentFactory() {
        Resource baseResource = this.getBaseResource();
        HttpContent.Factory contentFactory = new ResourceHttpContentFactory(baseResource, this._mimeTypes, this._byteBufferPool);
        contentFactory = new FileMappingHttpContentFactory(contentFactory);
        contentFactory = new VirtualHttpContentFactory(contentFactory, this.getStyleSheet(), "text/css", this._byteBufferPool);
        contentFactory = new PreCompressedHttpContentFactory(contentFactory, this._resourceService.getPrecompressedFormats());
        contentFactory = new ValidatingCachingHttpContentFactory(contentFactory, Duration.ofSeconds(1L).toMillis(), this._byteBufferPool);
        return contentFactory;
    }

    public Resource getBaseResource() {
        if (this._baseResource == null) {
            return this._context.getBaseResource();
        }
        return this._baseResource;
    }

    public String getCacheControl() {
        return this._resourceService.getCacheControl().getValue();
    }

    public List<String> getGzipEquivalentFileExtensions() {
        return this._resourceService.getGzipEquivalentFileExtensions();
    }

    public MimeTypes getMimeTypes() {
        return this._mimeTypes;
    }

    @Deprecated
    public String getResourceBase() {
        if (this._baseResource == null) {
            return null;
        }
        return this._baseResource.toString();
    }

    public Resource getStyleSheet() {
        if (this._styleSheet != null) {
            return this._styleSheet;
        }
        if (this._defaultStyleSheet == null) {
            this._defaultStyleSheet = this.getServer().getDefaultStyleSheet();
        }
        return this._defaultStyleSheet;
    }

    public String[] getWelcomeFiles() {
        return this._welcomes;
    }

    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (baseRequest.isHandled()) {
            return;
        }
        if (!HttpMethod.GET.is(request.getMethod()) && !HttpMethod.HEAD.is(request.getMethod())) {
            super.handle(target, baseRequest, request, response);
            return;
        }
        if (this._resourceService.doGet(request, response)) {
            baseRequest.setHandled(true);
        } else {
            super.handle(target, baseRequest, request, response);
        }
    }

    public boolean isAcceptRanges() {
        return this._resourceService.isAcceptRanges();
    }

    public boolean isDirAllowed() {
        return this._resourceService.isDirAllowed();
    }

    public boolean isDirectoriesListed() {
        return this._resourceService.isDirAllowed();
    }

    public boolean isEtags() {
        return this._resourceService.isEtags();
    }

    public CompressedContentFormat[] getPrecompressedFormats() {
        return this._resourceService.getPrecompressedFormats();
    }

    public boolean isPathInfoOnly() {
        return this._resourceService.isPathInfoOnly();
    }

    public boolean isRedirectWelcome() {
        return this._resourceService.isRedirectWelcome();
    }

    public int getByteBufferSize() {
        return this._byteBufferSize;
    }

    public boolean isUseDirectByteBuffers() {
        return this._useDirectByteBuffers;
    }

    public void setAcceptRanges(boolean acceptRanges) {
        this._resourceService.setAcceptRanges(acceptRanges);
    }

    public void setBaseResource(Resource base) {
        this._baseResource = base;
    }

    public void setBaseResource(Path basePath) {
        this.setBaseResource(ResourceFactory.root().newResource(basePath));
    }

    public void setCacheControl(String cacheControl) {
        this._resourceService.setCacheControl(new PreEncodedHttpField(HttpHeader.CACHE_CONTROL, cacheControl));
    }

    public void setDirAllowed(boolean dirAllowed) {
        this._resourceService.setDirAllowed(dirAllowed);
    }

    public void setDirectoriesListed(boolean directory) {
        this._resourceService.setDirAllowed(directory);
    }

    public void setEtags(boolean etags) {
        this._resourceService.setEtags(etags);
    }

    public void setGzipEquivalentFileExtensions(List<String> gzipEquivalentFileExtensions) {
        this._resourceService.setGzipEquivalentFileExtensions(gzipEquivalentFileExtensions);
    }

    public void setPrecompressedFormats(CompressedContentFormat[] precompressedFormats) {
        this._resourceService.setPrecompressedFormats(precompressedFormats);
    }

    public void setMimeTypes(MimeTypes mimeTypes) {
        this._mimeTypes = mimeTypes;
    }

    public void setPathInfoOnly(boolean pathInfoOnly) {
        this._resourceService.setPathInfoOnly(pathInfoOnly);
    }

    public void setRedirectWelcome(boolean redirectWelcome) {
        this._resourceService.setRedirectWelcome(redirectWelcome);
    }

    public void setByteBufferSize(int byteBufferSize) {
        this._byteBufferSize = byteBufferSize;
    }

    public void setUseDirectByteBuffers(boolean useDirectByteBuffers) {
        this._useDirectByteBuffers = useDirectByteBuffers;
    }

    @Deprecated
    public void setResourceBase(String resourceBase) {
        this.setBaseResourceAsString(resourceBase);
    }

    @Deprecated
    public void setBaseResourceAsString(String baseResource) {
        try {
            this.setBaseResource(ResourceFactory.of(this).newResource(baseResource));
        }
        catch (Exception e) {
            LOG.warn("Invalid Base Resource reference: {}", (Object)baseResource, (Object)e);
            throw new IllegalArgumentException(baseResource);
        }
    }

    public void setStyleSheet(String styleSheet) {
        try {
            this._styleSheet = ResourceFactory.of(this).newResource(styleSheet);
            if (!this._styleSheet.exists()) {
                LOG.warn("unable to find custom styleSheet: {}", (Object)styleSheet);
                this._styleSheet = null;
            }
        }
        catch (Exception e) {
            LOG.warn("Invalid StyleSheet reference: {}", (Object)styleSheet, (Object)e);
            throw new IllegalArgumentException(styleSheet);
        }
    }

    public void setWelcomeFiles(String[] welcomeFiles) {
        this._welcomes = welcomeFiles;
    }
}

