/*
 * Decompiled with CFR 0.152.
 */
package net.sf.json.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import net.sf.json.JSONObject;

public abstract class NewBeanInstanceStrategy {
    public static final NewBeanInstanceStrategy DEFAULT = new DefaultNewBeanInstanceStrategy();

    public abstract Object newInstance(Class var1, JSONObject var2) throws InstantiationException, IllegalAccessException, SecurityException, NoSuchMethodException, InvocationTargetException;

    private static final class DefaultNewBeanInstanceStrategy
    extends NewBeanInstanceStrategy {
        private static final Object[] EMPTY_ARGS = new Object[0];
        private static final Class[] EMPTY_PARAM_TYPES = new Class[0];

        private DefaultNewBeanInstanceStrategy() {
        }

        @Override
        public Object newInstance(Class target, JSONObject source) throws InstantiationException, IllegalAccessException, SecurityException, NoSuchMethodException, InvocationTargetException {
            if (target != null) {
                Constructor c = target.getDeclaredConstructor(EMPTY_PARAM_TYPES);
                c.setAccessible(true);
                try {
                    return c.newInstance(EMPTY_ARGS);
                }
                catch (InstantiationException e) {
                    String cause = "";
                    try {
                        cause = e.getCause() != null ? "\n" + e.getCause().getMessage() : "";
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    throw new InstantiationException("Instantiation of \"" + String.valueOf(target) + "\" failed. It's probably because class is an interface, abstract class, array class, primitive type or void." + cause);
                }
            }
            return null;
        }
    }
}

