/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ezmorph.array;

import java.lang.reflect.Array;
import java.util.Objects;
import net.sf.ezmorph.MorphException;
import net.sf.ezmorph.array.AbstractArrayMorpher;
import net.sf.ezmorph.primitive.BooleanMorpher;

public final class BooleanArrayMorpher
extends AbstractArrayMorpher {
    private static final Class BOOLEAN_ARRAY_CLASS = boolean[].class;
    private boolean defaultValue;

    public BooleanArrayMorpher() {
        super(false);
    }

    public BooleanArrayMorpher(boolean defaultValue) {
        super(true);
        this.defaultValue = defaultValue;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BooleanArrayMorpher)) {
            return false;
        }
        BooleanArrayMorpher other = (BooleanArrayMorpher)obj;
        if (this.isUseDefault() && other.isUseDefault()) {
            return Objects.equals(this.getDefaultValue(), other.getDefaultValue());
        }
        return !this.isUseDefault() && !other.isUseDefault();
    }

    public boolean getDefaultValue() {
        return this.defaultValue;
    }

    public int hashCode() {
        if (this.isUseDefault()) {
            return Objects.hashCode(this.getDefaultValue());
        }
        return 17;
    }

    @Override
    public Object morph(Object array) {
        if (array == null) {
            return null;
        }
        if (BOOLEAN_ARRAY_CLASS.isAssignableFrom(array.getClass())) {
            return (boolean[])array;
        }
        if (array.getClass().isArray()) {
            BooleanMorpher morpher;
            int length = Array.getLength(array);
            int dims = this.getDimensions(array.getClass());
            int[] dimensions = this.createDimensions(dims, length);
            Object result = Array.newInstance(Boolean.TYPE, dimensions);
            BooleanMorpher booleanMorpher = morpher = this.isUseDefault() ? new BooleanMorpher(this.defaultValue) : new BooleanMorpher();
            if (dims == 1) {
                for (int index = 0; index < length; ++index) {
                    Array.set(result, index, morpher.morph(Array.get(array, index)) ? Boolean.TRUE : Boolean.FALSE);
                }
            } else {
                for (int index = 0; index < length; ++index) {
                    Array.set(result, index, this.morph(Array.get(array, index)));
                }
            }
            return result;
        }
        throw new MorphException("argument is not an array: " + String.valueOf(array.getClass()));
    }

    @Override
    public Class morphsTo() {
        return BOOLEAN_ARRAY_CLASS;
    }
}

