/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jelly.tags.core;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.jelly.JellyContext;
import org.apache.commons.jelly.JellyException;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.TagLibrary;
import org.apache.commons.jelly.XMLOutput;
import org.apache.commons.jelly.impl.ExpressionAttribute;
import org.apache.commons.jelly.impl.TagScript;
import org.apache.commons.jelly.tags.core.ArgTag;
import org.apache.commons.jelly.tags.core.BreakTag;
import org.apache.commons.jelly.tags.core.CaseTag;
import org.apache.commons.jelly.tags.core.CatchTag;
import org.apache.commons.jelly.tags.core.ChooseTag;
import org.apache.commons.jelly.tags.core.DefaultTag;
import org.apache.commons.jelly.tags.core.ExprTag;
import org.apache.commons.jelly.tags.core.FileTag;
import org.apache.commons.jelly.tags.core.ForEachTag;
import org.apache.commons.jelly.tags.core.GetStaticTag;
import org.apache.commons.jelly.tags.core.IfTag;
import org.apache.commons.jelly.tags.core.ImportTag;
import org.apache.commons.jelly.tags.core.IncludeTag;
import org.apache.commons.jelly.tags.core.InvokeStaticTag;
import org.apache.commons.jelly.tags.core.InvokeTag;
import org.apache.commons.jelly.tags.core.JellyTag;
import org.apache.commons.jelly.tags.core.MuteTag;
import org.apache.commons.jelly.tags.core.NewTag;
import org.apache.commons.jelly.tags.core.OtherwiseTag;
import org.apache.commons.jelly.tags.core.ParseTag;
import org.apache.commons.jelly.tags.core.RemoveTag;
import org.apache.commons.jelly.tags.core.ScopeTag;
import org.apache.commons.jelly.tags.core.SetPropertiesTag;
import org.apache.commons.jelly.tags.core.SetTag;
import org.apache.commons.jelly.tags.core.SwitchTag;
import org.apache.commons.jelly.tags.core.ThreadTag;
import org.apache.commons.jelly.tags.core.UseBeanTag;
import org.apache.commons.jelly.tags.core.UseListTag;
import org.apache.commons.jelly.tags.core.WhenTag;
import org.apache.commons.jelly.tags.core.WhileTag;
import org.apache.commons.jelly.tags.core.WhitespaceTag;
import org.xml.sax.Attributes;

public class CoreTagLibrary
extends TagLibrary {
    private static final Logger LOGGER = Logger.getLogger(CoreTagLibrary.class.getName());

    public CoreTagLibrary() {
        this.registerTag("jelly", JellyTag.class);
        this.registerTag("out", ExprTag.class);
        this.registerTag("catch", CatchTag.class);
        this.registerTag("forEach", ForEachTag.class);
        this.registerTag("set", SetTag.class);
        this.registerTag("remove", RemoveTag.class);
        this.registerTag("while", WhileTag.class);
        this.registerTag("if", IfTag.class);
        this.registerTag("choose", ChooseTag.class);
        this.registerTag("when", WhenTag.class);
        this.registerTag("otherwise", OtherwiseTag.class);
        this.registerTag("switch", SwitchTag.class);
        this.registerTag("case", CaseTag.class);
        this.registerTag("default", DefaultTag.class);
        this.registerTag("include", IncludeTag.class);
        this.registerTag("import", ImportTag.class);
        this.registerTag("mute", MuteTag.class);
        this.registerTag("arg", ArgTag.class);
        this.registerTag("break", BreakTag.class);
        this.registerTag("expr", ExprTag.class);
        this.registerTag("file", FileTag.class);
        this.registerTag("getStatic", GetStaticTag.class);
        this.registerTag("invoke", InvokeTag.class);
        this.registerTag("invokeStatic", InvokeStaticTag.class);
        this.registerTag("new", NewTag.class);
        this.registerTag("parse", ParseTag.class);
        this.registerTag("scope", ScopeTag.class);
        this.registerTag("setProperties", SetPropertiesTag.class);
        this.registerTag("thread", ThreadTag.class);
        this.registerTag("useBean", UseBeanTag.class);
        this.registerTag("useList", UseListTag.class);
        this.registerTag("whitespace", WhitespaceTag.class);
    }

    @Override
    public TagScript createTagScript(String name, Attributes attributes) throws JellyException {
        if (name.equals("if")) {
            return new TagScript(){

                @Override
                public void run(JellyContext context, XMLOutput output) throws JellyTagException {
                    if (this.getAttribute("test").evaluateAsBoolean(context)) {
                        this.getTagBody().run(context, output);
                    }
                }
            };
        }
        if (name.equals("jelly")) {
            return new TagScript(){

                @Override
                public void run(JellyContext context, XMLOutput output) throws JellyTagException {
                    this.getTagBody().run(context, output);
                }
            };
        }
        if (name.equals("set")) {
            return new TagScript(){

                @Override
                public void run(JellyContext context, XMLOutput output) throws JellyTagException {
                    Object answer;
                    ExpressionAttribute value;
                    String var = this.getAttribute("var").evaluateAsString(context);
                    Object target = this.getAttribute("target").evaluate(context);
                    String property = this.getAttribute("property").evaluateAsString(context);
                    if (var != null) {
                        if (target != null || property != null) {
                            throw new JellyTagException("The 'target' and 'property' attributes cannot be used in combination with the 'var' attribute");
                        }
                    } else {
                        if (target == null) {
                            throw new JellyTagException("Either a 'var' or a 'target' attribute must be defined for this tag");
                        }
                        if (property == null) {
                            throw new JellyTagException("The 'target' attribute requires the 'property' attribute");
                        }
                    }
                    if ((value = (ExpressionAttribute)this.attributes.get("value")) != null) {
                        answer = value.exp.evaluate(context);
                        ExpressionAttribute defaultValue = (ExpressionAttribute)this.attributes.get("defaultValue");
                        if (defaultValue != null && this.isEmpty(answer)) {
                            answer = defaultValue.exp.evaluate(context);
                        }
                    } else {
                        answer = this.getBodyText(context, this.getAttribute("encode").evaluateAsBoolean(context));
                    }
                    if (var != null) {
                        String scope = this.getAttribute("scope").evaluateAsString(context);
                        if (scope != null) {
                            context.setVariable(var, scope, answer);
                        } else {
                            context.setVariable(var, answer);
                        }
                    } else {
                        this.setPropertyValue(target, property, answer);
                    }
                }

                protected void setPropertyValue(Object target, String property, Object value) {
                    try {
                        if (target instanceof Map) {
                            Map map = (Map)target;
                            map.put(property, value);
                        } else {
                            BeanUtils.setProperty((Object)target, (String)property, (Object)value);
                        }
                    }
                    catch (InvocationTargetException e) {
                        LOGGER.log(Level.WARNING, "Failed to set the property: " + property + " on bean: " + String.valueOf(target) + " to value: " + String.valueOf(value) + " due to exception: " + String.valueOf(e), e);
                    }
                    catch (IllegalAccessException e) {
                        LOGGER.log(Level.WARNING, "Failed to set the property: " + property + " on bean: " + String.valueOf(target) + " to value: " + String.valueOf(value) + " due to exception: " + String.valueOf(e), e);
                    }
                }

                protected boolean isEmpty(Object value) {
                    if (value == null) {
                        return true;
                    }
                    if (value instanceof String) {
                        String s = (String)value;
                        return s.length() == 0;
                    }
                    return false;
                }
            };
        }
        return super.createTagScript(name, attributes);
    }
}

