/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jelly.impl;

import org.apache.commons.jelly.JellyContext;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.Script;
import org.apache.commons.jelly.XMLOutput;
import org.xml.sax.SAXException;

public class TextScript
implements Script {
    private String text;

    public TextScript() {
    }

    public TextScript(String text) {
        this.text = text;
    }

    public String toString() {
        return super.toString() + "[text=" + this.text + "]";
    }

    public void trimWhitespace() {
        if (this.text.trim().length() == 0) {
            this.text = "";
        }
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    @Override
    public Script compile() {
        return this;
    }

    @Override
    public void run(JellyContext context, XMLOutput output) throws JellyTagException {
        if (this.text != null) {
            try {
                output.write(this.text);
            }
            catch (SAXException e) {
                throw new JellyTagException("could not write to XMLOutput", e);
            }
        }
    }
}

