/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.remoting.Channel;
import hudson.remoting.FileSystemJarCache;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.concurrent.CompletableFuture;

public abstract class JarCache {
    public static final File DEFAULT_NOWS_JAR_CACHE_LOCATION = new File(System.getProperty("user.home"), ".jenkins/cache/jars");

    @NonNull
    static JarCache getDefault() throws IOException {
        try {
            return new FileSystemJarCache(DEFAULT_NOWS_JAR_CACHE_LOCATION, true);
        }
        catch (IllegalArgumentException ex) {
            throw new IOException("Failed to initialize the default JAR Cache location", ex);
        }
    }

    @NonNull
    public abstract CompletableFuture<URL> resolve(@NonNull Channel var1, long var2, long var4) throws IOException, InterruptedException;
}

