/*
 * Decompiled with CFR 0.152.
 */
package jenkins.triggers;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.Util;
import hudson.console.ModelHyperlinkNote;
import hudson.model.AbstractBuild;
import hudson.model.AbstractItem;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.AutoCompletionCandidates;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.DependencyGraph;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Items;
import hudson.model.Job;
import hudson.model.Queue;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.ItemListener;
import hudson.model.listeners.RunListener;
import hudson.model.queue.Tasks;
import hudson.security.ACL;
import hudson.security.ACLContext;
import hudson.triggers.Trigger;
import hudson.triggers.TriggerDescriptor;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.DependencyDeclarer;
import jenkins.model.Jenkins;
import jenkins.model.ParameterizedJobMixIn;
import jenkins.triggers.Messages;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.core.Authentication;

public final class ReverseBuildTrigger
extends Trigger<Job>
implements DependencyDeclarer {
    private static final Logger LOGGER = Logger.getLogger(ReverseBuildTrigger.class.getName());
    @CheckForNull
    private String upstreamProjects;
    private Result threshold = Result.SUCCESS;

    @Deprecated
    public ReverseBuildTrigger(String upstreamProjects, Result threshold) {
        this(upstreamProjects);
        this.threshold = threshold;
    }

    @DataBoundConstructor
    public ReverseBuildTrigger(String upstreamProjects) {
        this.upstreamProjects = upstreamProjects;
    }

    public String getUpstreamProjects() {
        return Util.fixNull(this.upstreamProjects);
    }

    public Result getThreshold() {
        return this.threshold;
    }

    @DataBoundSetter
    public void setThreshold(Result r) {
        this.threshold = r;
    }

    private boolean shouldTrigger(Run upstreamBuild, TaskListener listener) {
        Jenkins jenkins = Jenkins.get();
        if (this.job == null) {
            return false;
        }
        boolean downstreamVisible = false;
        boolean downstreamDiscoverable = false;
        try {
            downstreamVisible = jenkins.getItemByFullName(((Job)this.job).getFullName()) == this.job;
        }
        catch (AccessDeniedException ex) {
            downstreamDiscoverable = true;
        }
        Authentication originalAuth = Jenkins.getAuthentication2();
        Object upstream = upstreamBuild.getParent();
        Authentication auth = Tasks.getAuthenticationOf2((Queue.Task)((Object)this.job));
        Item authUpstream = null;
        try (ACLContext ctx2 = ACL.as2(auth);){
            authUpstream = jenkins.getItemByFullName(((AbstractItem)upstream).getFullName());
        }
        catch (AccessDeniedException ctx2) {
            // empty catch block
        }
        if (authUpstream != upstream) {
            if (downstreamVisible) {
                listener.getLogger().println(Messages.ReverseBuildTrigger_running_as_cannot_even_see_for_trigger_f(auth.getName(), ((AbstractItem)upstream).getFullName(), ((Job)this.job).getFullName()));
            } else {
                LOGGER.log(Level.WARNING, "Running as {0} cannot even {1} {2} for trigger from {3}, (but cannot tell {4} that)", new Object[]{auth.getName(), downstreamDiscoverable ? "READ" : "DISCOVER", upstream, this.job, originalAuth.getName()});
            }
            return false;
        }
        Result result = upstreamBuild.getResult();
        return result != null && result.isBetterOrEqualTo(this.threshold != null ? this.threshold : Result.SUCCESS);
    }

    @Override
    public void buildDependencyGraph(AbstractProject downstream, DependencyGraph graph) {
        for (AbstractProject upstream : Items.fromNameList(downstream.getParent(), this.getUpstreamProjects(), AbstractProject.class)) {
            graph.addDependency(new DependencyGraph.Dependency(upstream, downstream){

                @Override
                public boolean shouldTriggerBuild(AbstractBuild upstreamBuild, TaskListener listener, List<Action> actions) {
                    return ReverseBuildTrigger.this.shouldTrigger(upstreamBuild, listener);
                }
            });
        }
    }

    @Override
    public void start(@NonNull Job project, boolean newInstance) {
        super.start(project, newInstance);
        RunListenerImpl.get().invalidateCache();
    }

    @Override
    public void stop() {
        super.stop();
        RunListenerImpl.get().invalidateCache();
    }

    @Extension
    public static final class RunListenerImpl
    extends RunListener<Run> {
        private Map<Job, Collection<ReverseBuildTrigger>> upstream2Trigger;

        static RunListenerImpl get() {
            return ExtensionList.lookupSingleton(RunListenerImpl.class);
        }

        synchronized void invalidateCache() {
            this.upstream2Trigger = null;
        }

        private Map<Job, Collection<ReverseBuildTrigger>> calculateCache() {
            try (ACLContext acl = ACL.as2(ACL.SYSTEM2);){
                WeakHashMap<Job, Collection> result = new WeakHashMap<Job, Collection>();
                for (Job downstream : Jenkins.get().allItems(Job.class)) {
                    ReverseBuildTrigger trigger = ParameterizedJobMixIn.getTrigger(downstream, ReverseBuildTrigger.class);
                    if (trigger == null) continue;
                    List<Job> upstreams = Items.fromNameList(downstream.getParent(), trigger.getUpstreamProjects(), Job.class);
                    LOGGER.log(Level.FINE, "from {0} see upstreams {1}", new Object[]{downstream, upstreams});
                    for (Job upstream : upstreams) {
                        if (upstream instanceof AbstractProject && downstream instanceof AbstractProject) continue;
                        Collection triggers = result.computeIfAbsent(upstream, k -> new ArrayList());
                        triggers.remove(trigger);
                        triggers.add(trigger);
                    }
                }
                WeakHashMap<Job, Collection> weakHashMap = result;
                return weakHashMap;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCompleted(@NonNull Run r, @NonNull TaskListener listener) {
            ArrayList<ReverseBuildTrigger> triggers;
            RunListenerImpl runListenerImpl = this;
            synchronized (runListenerImpl) {
                Collection<ReverseBuildTrigger> _triggers;
                if (this.upstream2Trigger == null) {
                    this.upstream2Trigger = this.calculateCache();
                }
                if ((_triggers = this.upstream2Trigger.get(r.getParent())) == null || _triggers.isEmpty()) {
                    return;
                }
                triggers = new ArrayList<ReverseBuildTrigger>(_triggers);
            }
            for (ReverseBuildTrigger trigger : triggers) {
                if (!trigger.shouldTrigger(r, listener) || trigger.job == null) continue;
                if (!((Job)trigger.job).isBuildable()) {
                    listener.getLogger().println(hudson.tasks.Messages.BuildTrigger_Disabled(ModelHyperlinkNote.encodeTo(trigger.job)));
                    continue;
                }
                String name = ModelHyperlinkNote.encodeTo(trigger.job) + " #" + ((Job)trigger.job).getNextBuildNumber();
                if (ParameterizedJobMixIn.scheduleBuild2((Job)trigger.job, -1, new CauseAction((Cause)new Cause.UpstreamCause(r))) != null) {
                    listener.getLogger().println(hudson.tasks.Messages.BuildTrigger_Triggering(name));
                    continue;
                }
                listener.getLogger().println(hudson.tasks.Messages.BuildTrigger_InQueue(name));
            }
        }
    }

    @Extension
    public static class ItemListenerImpl
    extends ItemListener {
        @Override
        public void onLocationChanged(Item item, String oldFullName, String newFullName) {
            try (ACLContext acl = ACL.as2(ACL.SYSTEM2);){
                for (Job p : Jenkins.get().allItems(Job.class)) {
                    String revised;
                    ReverseBuildTrigger t = ParameterizedJobMixIn.getTrigger(p, ReverseBuildTrigger.class);
                    if (t == null || (revised = Items.computeRelativeNamesAfterRenaming(oldFullName, newFullName, t.getUpstreamProjects(), p.getParent())).equals(t.upstreamProjects)) continue;
                    t.upstreamProjects = revised;
                    try {
                        p.save();
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.WARNING, "Failed to persist project setting during rename from " + oldFullName + " to " + newFullName, e);
                    }
                }
            }
        }
    }

    @Extension
    @Symbol(value={"upstream"})
    public static final class DescriptorImpl
    extends TriggerDescriptor {
        @Override
        @NonNull
        public String getDisplayName() {
            return Messages.ReverseBuildTrigger_build_after_other_projects_are_built();
        }

        @Override
        public boolean isApplicable(Item item) {
            return item instanceof Job && item instanceof ParameterizedJobMixIn.ParameterizedJob;
        }

        public AutoCompletionCandidates doAutoCompleteUpstreamProjects(@QueryParameter String value, @AncestorInPath Item self, @AncestorInPath ItemGroup container) {
            return AutoCompletionCandidates.ofJobNames(Job.class, value, self, container);
        }

        public FormValidation doCheckUpstreamProjects(@AncestorInPath Job project, @QueryParameter String value) {
            if (!project.hasPermission(Item.CONFIGURE)) {
                return FormValidation.ok();
            }
            StringTokenizer tokens = new StringTokenizer(Util.fixNull(value), ",");
            boolean hasProjects = false;
            while (tokens.hasMoreTokens()) {
                String projectName = tokens.nextToken().trim();
                if (projectName == null || projectName.isBlank()) continue;
                Job item = Jenkins.get().getItem(projectName, project, Job.class);
                if (item == null) {
                    Job nearest = Items.findNearest(Job.class, projectName, project.getParent());
                    String alternative = nearest != null ? nearest.getRelativeNameFrom(project) : "?";
                    return FormValidation.error(hudson.tasks.Messages.BuildTrigger_NoSuchProject(projectName, alternative));
                }
                hasProjects = true;
            }
            if (!hasProjects) {
                return FormValidation.error(hudson.tasks.Messages.BuildTrigger_NoProjectSpecified());
            }
            return FormValidation.ok();
        }
    }
}

