/*
 * Decompiled with CFR 0.152.
 */
package jenkins.tasks;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.console.ConsoleLogFilter;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildWrapper;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.Beta;

public abstract class SimpleBuildWrapper
extends BuildWrapper {
    public boolean requiresWorkspace() {
        return true;
    }

    public void setUp(Context context, Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener, EnvVars initialEnvironment) throws IOException, InterruptedException {
        if (!this.requiresWorkspace()) {
            this.setUp(context, build, listener, initialEnvironment);
            return;
        }
        throw new AbstractMethodError("Unless a build wrapper is marked as not requiring a workspace context, you must implement the overload of the setUp() method that takes both a workspace and a launcher.");
    }

    public void setUp(Context context, Run<?, ?> build, TaskListener listener, EnvVars initialEnvironment) throws IOException, InterruptedException {
        if (this.requiresWorkspace()) {
            throw new IllegalStateException("This build wrapper requires a workspace context, but none was provided.");
        }
        throw new AbstractMethodError("When a build wrapper is marked as not requiring a workspace context, you must implement the overload of the setUp() method that does not take a workspace or launcher.");
    }

    @Restricted(value={Beta.class})
    public Context createContext() {
        return new Context(this.requiresWorkspace());
    }

    protected boolean runPreCheckout() {
        return false;
    }

    @Override
    public final BuildWrapper.Environment setUp(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        if (this.runPreCheckout()) {
            return new BuildWrapper.Environment(this){};
        }
        Context c = this.createContext();
        this.setUp(c, build, build.getWorkspace(), launcher, listener, build.getEnvironment(listener));
        return new EnvironmentWrapper(this, c, launcher);
    }

    @Override
    public final void preCheckout(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        if (this.runPreCheckout()) {
            Context c = this.createContext();
            this.setUp(c, build, build.getWorkspace(), launcher, listener, build.getEnvironment(listener));
            build.getEnvironments().add(new EnvironmentWrapper(this, c, launcher));
        }
    }

    @CheckForNull
    public ConsoleLogFilter createLoggerDecorator(@NonNull Run<?, ?> build) {
        return null;
    }

    @Override
    public final OutputStream decorateLogger(AbstractBuild build, OutputStream logger) throws IOException, InterruptedException, Run.RunnerAbortedException {
        ConsoleLogFilter filter = this.createLoggerDecorator(build);
        return filter != null ? filter.decorateLogger(build, logger) : logger;
    }

    @Override
    public Launcher decorateLauncher(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException, Run.RunnerAbortedException {
        return super.decorateLauncher(build, launcher, listener);
    }

    @Override
    public void makeBuildVariables(AbstractBuild build, Map<String, String> variables) {
        super.makeBuildVariables(build, variables);
    }

    @Override
    public void makeSensitiveBuildVariables(AbstractBuild build, Set<String> sensitiveVariables) {
        super.makeSensitiveBuildVariables(build, sensitiveVariables);
    }

    @Override
    public final Collection<? extends Action> getProjectActions(AbstractProject job) {
        return Collections.emptySet();
    }

    public static final class Context {
        private Disposer disposer;
        private final Map<String, String> env = new HashMap<String, String>();
        @CheckForNull
        private final Boolean wrapperRequiresWorkspace;

        @Deprecated
        public Context() {
            this.wrapperRequiresWorkspace = null;
        }

        private Context(boolean wrapperRequiresWorkspace) {
            this.wrapperRequiresWorkspace = wrapperRequiresWorkspace;
        }

        public void env(String key, String value) {
            if (this.env.containsKey(key)) {
                throw new IllegalStateException("just one binding for " + key);
            }
            this.env.put(key, value);
        }

        @CheckForNull
        public Disposer getDisposer() {
            return this.disposer;
        }

        @NonNull
        public Map<String, String> getEnv() {
            return this.env;
        }

        public void setDisposer(@NonNull Disposer disposer) {
            if (this.disposer != null) {
                throw new IllegalStateException("just one disposer");
            }
            disposer.wrapperRequiresWorkspace = this.wrapperRequiresWorkspace;
            this.disposer = disposer;
        }
    }

    private class EnvironmentWrapper
    extends BuildWrapper.Environment {
        private final Context c;
        private final Launcher launcher;

        EnvironmentWrapper(SimpleBuildWrapper simpleBuildWrapper, Context c, Launcher launcher) {
            super(simpleBuildWrapper);
            this.c = c;
            this.launcher = launcher;
        }

        @Override
        public void buildEnvVars(Map<String, String> env) {
            if (env instanceof EnvVars) {
                ((EnvVars)env).overrideAll(this.c.env);
            } else {
                env.putAll(this.c.env);
            }
        }

        @Override
        public boolean tearDown(AbstractBuild build, BuildListener listener) throws IOException, InterruptedException {
            if (this.c.disposer != null) {
                this.c.disposer.tearDown(build, build.getWorkspace(), this.launcher, listener);
            }
            return true;
        }
    }

    public static abstract class Disposer
    implements Serializable {
        @CheckForNull
        private Boolean wrapperRequiresWorkspace;

        @Restricted(value={Beta.class})
        public final boolean requiresWorkspace() {
            return this.wrapperRequiresWorkspace == null || this.wrapperRequiresWorkspace != false;
        }

        public void tearDown(Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
            if (!this.requiresWorkspace()) {
                this.tearDown(build, listener);
                return;
            }
            throw new AbstractMethodError("Unless an end-of-wrapped-block callback is marked as not requiring a workspace context, you must implement the overload of the tearDown() method that takes both a workspace and a launcher.");
        }

        public void tearDown(Run<?, ?> build, TaskListener listener) throws IOException, InterruptedException {
            if (this.requiresWorkspace()) {
                throw new IllegalStateException("This end-of-wrapped-block callback requires a workspace context, but none was provided.");
            }
            throw new AbstractMethodError("When an end-of-wrapped-block callback is marked as not requiring a workspace context, you must implement the overload of the tearDown() method that does not take a workspace or launcher.");
        }
    }
}

