/*
 * Decompiled with CFR 0.152.
 */
package jenkins.security.csp.impl;

import hudson.Extension;
import hudson.model.User;
import hudson.tasks.UserAvatarResolver;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.security.csp.AvatarContributor;
import jenkins.security.csp.Contributor;
import jenkins.security.csp.CspBuilder;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
@Extension
public class UserAvatarContributor
implements Contributor {
    private static final Logger LOGGER = Logger.getLogger(UserAvatarContributor.class.getName());

    @Override
    public void apply(CspBuilder cspBuilder) {
        User user = User.current();
        if (user == null) {
            return;
        }
        String url = UserAvatarResolver.resolveOrNull(user, "96x96");
        if (url == null) {
            LOGGER.log(Level.FINE, "No avatar image found for user " + user.getId());
            return;
        }
        cspBuilder.add("img-src", AvatarContributor.extractDomainFromUrl(url));
    }
}

