/*
 * Decompiled with CFR 0.152.
 */
package jenkins.security.csp.impl;

import hudson.Extension;
import hudson.ExtensionList;
import hudson.model.InvisibleAction;
import hudson.model.UnprotectedRootAction;
import hudson.model.User;
import hudson.security.csrf.CrumbExclusion;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.security.csp.CspReceiver;
import jenkins.security.csp.ReportingContext;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.BoundedInputStream;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.verb.POST;

@Restricted(value={NoExternalUse.class})
@Extension
public class ReportingAction
extends InvisibleAction
implements UnprotectedRootAction {
    public static final String URL = "content-security-policy-reporting-endpoint";
    private static final Logger LOGGER = Logger.getLogger(ReportingAction.class.getName());
    private static int MAX_REPORT_LENGTH = 20480;

    @Override
    public String getUrlName() {
        return URL;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @POST
    public HttpResponse doDynamic(StaplerRequest2 req) {
        String requestRestOfPath = req.getRestOfPath();
        String restOfPath = requestRestOfPath.startsWith("/") ? requestRestOfPath.substring(1) : requestRestOfPath;
        try {
            ReportingContext.DecodedContext context = ReportingContext.decodeContext(restOfPath);
            CspReceiver.ViewContext viewContext = new CspReceiver.ViewContext(context.contextClassName(), context.restOfPath());
            boolean[] maxReached = new boolean[1];
            try (ServletInputStream is = req.getInputStream();
                 BoundedInputStream bis = ((BoundedInputStream.Builder)((BoundedInputStream.Builder)((BoundedInputStream.Builder)BoundedInputStream.builder().setMaxCount((long)MAX_REPORT_LENGTH)).setOnMaxCount((x, y) -> {
                maxReached[0] = true;
            })).setInputStream((InputStream)is)).get();){
                JSONObject jsonObject;
                String report = IOUtils.toString((InputStream)bis, (String)req.getCharacterEncoding());
                if (maxReached[0]) {
                    LOGGER.log(Level.FINE, () -> "Report for " + String.valueOf(viewContext) + " exceeded max length of " + MAX_REPORT_LENGTH);
                    HttpResponses.HttpResponseException httpResponseException = HttpResponses.ok();
                    return httpResponseException;
                }
                LOGGER.log(Level.FINEST, () -> "Report for " + String.valueOf(viewContext) + " length: " + report.length());
                LOGGER.log(Level.FINER, () -> String.valueOf(viewContext) + " " + report);
                try {
                    jsonObject = JSONObject.fromObject((Object)report);
                }
                catch (JSONException ex) {
                    LOGGER.log(Level.FINE, ex, () -> "Failed to parse JSON report for " + String.valueOf(viewContext) + ": " + report);
                    HttpResponses.HttpResponseException httpResponseException = HttpResponses.ok();
                    if (bis != null) {
                        bis.close();
                    }
                    if (is == null) return httpResponseException;
                    is.close();
                    return httpResponseException;
                }
                User user = context.userId() != null ? User.getById(context.userId(), false) : null;
                Iterator<CspReceiver> iterator = ExtensionList.lookup(CspReceiver.class).iterator();
                while (iterator.hasNext()) {
                    CspReceiver receiver = iterator.next();
                    try {
                        receiver.report(viewContext, user == null ? null : context.userId(), jsonObject);
                    }
                    catch (Exception ex) {
                        LOGGER.log(Level.WARNING, ex, () -> "Error reporting CSP for " + String.valueOf(viewContext) + " to " + String.valueOf(receiver));
                    }
                }
                return HttpResponses.ok();
            }
            catch (IOException e) {
                LOGGER.log(Level.FINE, e, () -> "Failed to read request body for " + String.valueOf(viewContext));
            }
            return HttpResponses.ok();
        }
        catch (RuntimeException ex) {
            LOGGER.log(Level.FINE, ex, () -> "Unexpected rest of path failed to decode: " + restOfPath);
            return HttpResponses.ok();
        }
    }

    @Extension
    public static class CrumbExclusionImpl
    extends CrumbExclusion {
        @Override
        public boolean process(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
            String pathInfo = request.getPathInfo();
            if (pathInfo != null && pathInfo.startsWith("/content-security-policy-reporting-endpoint/")) {
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
                return true;
            }
            return false;
        }
    }
}

