/*
 * Decompiled with CFR 0.152.
 */
package jenkins.security.csp.impl;

import hudson.ExtensionList;
import hudson.Functions;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.security.ResourceDomainConfiguration;
import jenkins.security.csp.impl.CspDecorator;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class CspFilter
implements Filter {
    private static final Logger LOGGER = Logger.getLogger(CspFilter.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req;
        block18: {
            block17: {
                if (!(request instanceof HttpServletRequest)) break block17;
                req = (HttpServletRequest)request;
                if (response instanceof HttpServletResponse) break block18;
            }
            chain.doFilter(request, response);
            return;
        }
        HttpServletResponse rsp = (HttpServletResponse)response;
        if (!Functions.isExtensionsAvailable()) {
            LOGGER.log(Level.FINER, "Extensions are not available, so skipping CSP enforcement for: " + req.getRequestURI());
            chain.doFilter(request, response);
            return;
        }
        CspDecorator cspDecorator = ExtensionList.lookupSingleton(CspDecorator.class);
        String headerName = cspDecorator.getContentSecurityPolicyHeaderName();
        boolean headerShouldBeSet = headerName != null;
        String headerValue = cspDecorator.getContentSecurityPolicyHeaderValue(req);
        boolean isResourceRequest = ResourceDomainConfiguration.isResourceRequest(req);
        if (headerShouldBeSet && !isResourceRequest) {
            String reportingEndpoints = cspDecorator.getReportingEndpointsHeaderValue(req);
            if (reportingEndpoints != null) {
                rsp.setHeader("Reporting-Endpoints", reportingEndpoints);
            }
            rsp.setHeader(headerName, headerValue);
        }
        try {
            chain.doFilter((ServletRequest)req, (ServletResponse)rsp);
        }
        finally {
            if (headerShouldBeSet) {
                try {
                    String actualHeader = rsp.getHeader(headerName);
                    if (!isResourceRequest && CspFilter.hasUnexpectedDifference(headerValue, actualHeader)) {
                        LOGGER.log(Level.FINE, "CSP header has unexpected differences: Expected '" + headerValue + "' but got '" + actualHeader + "'");
                    }
                }
                catch (RuntimeException e) {
                    LOGGER.log(Level.FINER, "Error checking CSP header after request processing", e);
                }
            }
        }
    }

    private static boolean hasUnexpectedDifference(String headerByFilter, String actualHeader) {
        if (actualHeader == null) {
            return true;
        }
        String expectedPrefix = headerByFilter.substring(0, headerByFilter.indexOf(" report-uri "));
        if (!actualHeader.contains(" report-uri ")) {
            return true;
        }
        String actualPrefix = actualHeader.substring(0, actualHeader.indexOf(" report-uri "));
        return !expectedPrefix.equals(actualPrefix);
    }
}

