/*
 * Decompiled with CFR 0.152.
 */
package jenkins.security.csp.impl;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.Extension;
import hudson.model.PageDecorator;
import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.security.csp.CspBuilder;
import jenkins.security.csp.CspHeader;
import jenkins.security.csp.CspHeaderDecider;
import jenkins.security.csp.ReportingContext;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.Ancestor;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest2;

@Restricted(value={NoExternalUse.class})
@Extension
public class CspDecorator
extends PageDecorator {
    private static final String REPORTING_ENDPOINT_NAME = "content-security-policy";
    private static final Logger LOGGER = Logger.getLogger(CspDecorator.class.getName());

    public String getContentSecurityPolicyHeaderValue(HttpServletRequest req) {
        Object cspDirectives = new CspBuilder().withDefaultContributions().build();
        String reportingEndpoint = CspDecorator.getReportingEndpoint(req);
        if (reportingEndpoint != null) {
            cspDirectives = (String)cspDirectives + " report-to content-security-policy; report-uri " + reportingEndpoint;
        }
        return cspDirectives;
    }

    @CheckForNull
    public String getReportingEndpointsHeaderValue(HttpServletRequest req) {
        String reportingEndpoint = CspDecorator.getReportingEndpoint(req);
        if (reportingEndpoint == null) {
            return null;
        }
        return "content-security-policy: " + reportingEndpoint;
    }

    @CheckForNull
    static String getReportingEndpoint(HttpServletRequest req) {
        String rootUrl;
        List ancestors;
        Class<?> modelObjectClass = null;
        String restOfPath = StringUtils.removeStart((String)req.getRequestURI(), (String)req.getContextPath());
        StaplerRequest2 staplerRequest2 = Stapler.getCurrentRequest2();
        if (staplerRequest2 != null && !(ancestors = staplerRequest2.getAncestors()).isEmpty()) {
            Ancestor nearest = (Ancestor)ancestors.get(ancestors.size() - 1);
            restOfPath = nearest.getRestOfUrl();
            modelObjectClass = nearest.getObject().getClass();
        }
        try {
            rootUrl = Jenkins.get().getRootUrlFromRequest();
        }
        catch (IllegalStateException e) {
            LOGGER.log(Level.FINEST, "Cannot get root URL from request", e);
            try {
                rootUrl = Jenkins.get().getRootUrl();
            }
            catch (IllegalStateException ise) {
                LOGGER.log(Level.FINEST, "Cannot get root URL from configuration", ise);
                return null;
            }
        }
        if (rootUrl == null) {
            return null;
        }
        return rootUrl + "content-security-policy-reporting-endpoint/" + ReportingContext.encodeContext(modelObjectClass, Jenkins.getAuthentication2(), restOfPath);
    }

    @CheckForNull
    public String getContentSecurityPolicyHeaderName() {
        Optional<CspHeaderDecider> decider = CspHeaderDecider.getCurrentDecider();
        if (decider.isPresent()) {
            CspHeaderDecider presentDecider = decider.get();
            LOGGER.log(Level.FINEST, "Choosing header from decider " + presentDecider.getClass().getName());
            Optional<CspHeader> decision = presentDecider.decide();
            if (decision.isPresent()) {
                return decision.get().getHeaderName();
            }
            LOGGER.log(Level.FINE, "Decider changed its mind after selection: " + presentDecider.getClass().getName());
        }
        LOGGER.log(Level.WARNING, "Failed to find a CspHeaderDecider, falling back to default");
        return CspHeader.ContentSecurityPolicyReportOnly.getHeaderName();
    }
}

