/*
 * Decompiled with CFR 0.152.
 */
package jenkins.security.csp;

import java.util.Optional;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.Beta;

@Restricted(value={Beta.class})
public enum FetchDirective {
    DEFAULT_SRC("default-src"),
    CHILD_SRC("child-src"),
    CONNECT_SRC("connect-src"),
    FONT_SRC("font-src"),
    FRAME_SRC("frame-src"),
    IMG_SRC("img-src"),
    MANIFEST_SRC("manifest-src"),
    MEDIA_SRC("media-src"),
    OBJECT_SRC("object-src"),
    PREFETCH_SRC("prefetch-src"),
    SCRIPT_SRC("script-src"),
    SCRIPT_SRC_ELEM("script-src-elem"),
    SCRIPT_SRC_ATTR("script-src-attr"),
    STYLE_SRC("style-src"),
    STYLE_SRC_ELEM("style-src-elem"),
    STYLE_SRC_ATTR("style-src-attr"),
    WORKER_SRC("worker-src");

    private final String key;

    private FetchDirective(String s) {
        this.key = s;
    }

    public String toKey() {
        return this.key;
    }

    public static FetchDirective fromKey(String s) {
        for (FetchDirective e : FetchDirective.values()) {
            if (!e.key.equals(s)) continue;
            return e;
        }
        throw new IllegalArgumentException("Key not found: " + s);
    }

    public static boolean isFetchDirective(String key) {
        return FetchDirective.toFetchDirective(key).isPresent();
    }

    public static Optional<FetchDirective> toFetchDirective(String key) {
        try {
            return Optional.of(FetchDirective.fromKey(key));
        }
        catch (IllegalArgumentException e) {
            return Optional.empty();
        }
    }

    public FetchDirective getFallback() {
        if (this == SCRIPT_SRC_ATTR || this == SCRIPT_SRC_ELEM) {
            return SCRIPT_SRC;
        }
        if (this == STYLE_SRC_ATTR || this == STYLE_SRC_ELEM) {
            return STYLE_SRC;
        }
        if (this == FRAME_SRC || this == WORKER_SRC) {
            return CHILD_SRC;
        }
        if (this != DEFAULT_SRC) {
            return DEFAULT_SRC;
        }
        return null;
    }
}

