/*
 * Decompiled with CFR 0.152.
 */
package jenkins.security;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import jenkins.util.InterceptingExecutorService;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

public class SecurityContextExecutorService
extends InterceptingExecutorService {
    public SecurityContextExecutorService(ExecutorService service) {
        super(service);
    }

    @Override
    protected Runnable wrap(final Runnable r) {
        final SecurityContext callingContext = SecurityContextHolder.getContext();
        return new Runnable(){

            @Override
            public void run() {
                SecurityContext old = SecurityContextHolder.getContext();
                SecurityContextHolder.setContext((SecurityContext)callingContext);
                try {
                    r.run();
                }
                finally {
                    SecurityContextHolder.setContext((SecurityContext)old);
                }
            }
        };
    }

    @Override
    protected <V> Callable<V> wrap(final Callable<V> c) {
        final SecurityContext callingContext = SecurityContextHolder.getContext();
        return new Callable<V>(this){

            @Override
            public V call() throws Exception {
                SecurityContext old = SecurityContextHolder.getContext();
                SecurityContextHolder.setContext((SecurityContext)callingContext);
                try {
                    Object v = c.call();
                    return v;
                }
                finally {
                    SecurityContextHolder.setContext((SecurityContext)old);
                }
            }
        };
    }
}

