/*
 * Decompiled with CFR 0.152.
 */
package jenkins.model;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.ExtensionListListener;
import hudson.ExtensionPoint;
import hudson.model.Action;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public abstract class TransientActionFactory<T>
implements ExtensionPoint {
    public abstract Class<T> type();

    public Class<? extends Action> actionType() {
        return Action.class;
    }

    @NonNull
    public abstract Collection<? extends Action> createFor(@NonNull T var1);

    @Restricted(value={NoExternalUse.class})
    public static Iterable<? extends TransientActionFactory<?>> factoriesFor(Class<?> type, Class<? extends Action> actionType) {
        return ExtensionList.lookupSingleton(Cache.class).cache().get(type).get(actionType);
    }

    @Restricted(value={NoExternalUse.class})
    @Extension
    public static final class Cache
    extends ExtensionListListener {
        private ExtensionList<TransientActionFactory> allFactories;
        private ClassValue<ClassValue<List<TransientActionFactory<?>>>> cache;

        private synchronized ClassValue<ClassValue<List<TransientActionFactory<?>>>> cache() {
            if (this.allFactories == null) {
                this.allFactories = ExtensionList.lookup(TransientActionFactory.class);
                this.allFactories.addListener(this);
            }
            if (this.cache == null) {
                this.cache = new ClassValue<ClassValue<List<TransientActionFactory<?>>>>(){

                    @Override
                    protected ClassValue<List<TransientActionFactory<?>>> computeValue(final Class<?> type) {
                        return new ClassValue<List<TransientActionFactory<?>>>(){

                            @Override
                            protected List<TransientActionFactory<?>> computeValue(Class<?> actionType) {
                                ArrayList factories = new ArrayList();
                                for (TransientActionFactory taf : allFactories) {
                                    if (!taf.type().isAssignableFrom(type) || !actionType.isAssignableFrom(taf.actionType()) && !taf.actionType().isAssignableFrom(actionType)) continue;
                                    factories.add(taf);
                                }
                                return factories;
                            }
                        };
                    }
                };
            }
            return this.cache;
        }

        @Override
        public synchronized void onChange() {
            this.cache = null;
        }
    }
}

