/*
 * Decompiled with CFR 0.152.
 */
package jenkins.model;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.Util;
import hudson.model.Job;
import hudson.model.Messages;
import hudson.model.PermalinkProjectAction;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import hudson.util.AtomicFileWriter;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.Beta;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public abstract class PeepholePermalink
extends PermalinkProjectAction.Permalink
implements Predicate<Run<?, ?>> {
    public static final PermalinkProjectAction.Permalink LAST_STABLE_BUILD = new PeepholePermalink(){

        @Override
        public String getDisplayName() {
            return Messages.Permalink_LastStableBuild();
        }

        @Override
        public String getId() {
            return "lastStableBuild";
        }

        @Override
        public boolean apply(Run<?, ?> run) {
            return !run.isBuilding() && run.getResult() == Result.SUCCESS;
        }
    };
    public static final PermalinkProjectAction.Permalink LAST_SUCCESSFUL_BUILD = new PeepholePermalink(){

        @Override
        public String getDisplayName() {
            return Messages.Permalink_LastSuccessfulBuild();
        }

        @Override
        public String getId() {
            return "lastSuccessfulBuild";
        }

        @Override
        @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="TODO needs triage")
        public boolean apply(Run<?, ?> run) {
            return !run.isBuilding() && run.getResult().isBetterOrEqualTo(Result.UNSTABLE);
        }
    };
    public static final PermalinkProjectAction.Permalink LAST_FAILED_BUILD = new PeepholePermalink(){

        @Override
        public String getDisplayName() {
            return Messages.Permalink_LastFailedBuild();
        }

        @Override
        public String getId() {
            return "lastFailedBuild";
        }

        @Override
        public boolean apply(Run<?, ?> run) {
            return !run.isBuilding() && run.getResult() == Result.FAILURE;
        }
    };
    public static final PermalinkProjectAction.Permalink LAST_UNSTABLE_BUILD = new PeepholePermalink(){

        @Override
        public String getDisplayName() {
            return Messages.Permalink_LastUnstableBuild();
        }

        @Override
        public String getId() {
            return "lastUnstableBuild";
        }

        @Override
        public boolean apply(Run<?, ?> run) {
            return !run.isBuilding() && run.getResult() == Result.UNSTABLE;
        }
    };
    public static final PermalinkProjectAction.Permalink LAST_UNSUCCESSFUL_BUILD = new PeepholePermalink(){

        @Override
        public String getDisplayName() {
            return Messages.Permalink_LastUnsuccessfulBuild();
        }

        @Override
        public String getId() {
            return "lastUnsuccessfulBuild";
        }

        @Override
        public boolean apply(Run<?, ?> run) {
            return !run.isBuilding() && run.getResult() != Result.SUCCESS;
        }
    };
    public static final PermalinkProjectAction.Permalink LAST_COMPLETED_BUILD = new PeepholePermalink(){

        @Override
        public String getDisplayName() {
            return Messages.Permalink_LastCompletedBuild();
        }

        @Override
        public String getId() {
            return "lastCompletedBuild";
        }

        @Override
        public boolean apply(Run<?, ?> run) {
            return !run.isBuilding();
        }
    };
    private static final Logger LOGGER;

    public abstract boolean apply(Run<?, ?> var1);

    @Override
    public boolean test(Run<?, ?> run) {
        return this.apply(run);
    }

    @Deprecated
    protected File getPermalinkFile(Job<?, ?> job) {
        return new File(job.getBuildDir(), this.getId());
    }

    @Override
    public Run<?, ?> resolve(Job<?, ?> job) {
        return this.get(job).resolve(this, job, this.getId());
    }

    Cache.PermalinkTarget get(Job<?, ?> job) {
        return ExtensionList.lookupFirst(Cache.class).get(job, this.getId());
    }

    int resolveNumber(Job<?, ?> job) {
        Cache.PermalinkTarget pt = this.get(job);
        if (pt instanceof Cache.Some) {
            Cache.Some some = (Cache.Some)pt;
            return some.number;
        }
        if (pt instanceof Cache.None) {
            return 0;
        }
        Run<?, ?> b = pt.resolve(this, job, this.getId());
        return b != null ? b.number : 0;
    }

    @CheckForNull
    private Run<?, ?> find(@CheckForNull Run<?, ?> b) {
        while (b != null && !this.apply(b)) {
            b = b.getPreviousBuild();
        }
        return b;
    }

    protected void updateCache(@NonNull Job<?, ?> job, @CheckForNull Run<?, ?> b) {
        ExtensionList.lookupFirst(Cache.class).put(job, this.getId(), (Cache.Known)((Object)(b != null ? new Cache.Some(b.getNumber()) : Cache.NONE)));
    }

    @Restricted(value={NoExternalUse.class})
    public static void initialized() {
    }

    static {
        BUILTIN.add(LAST_STABLE_BUILD);
        BUILTIN.add(LAST_SUCCESSFUL_BUILD);
        BUILTIN.add(LAST_FAILED_BUILD);
        BUILTIN.add(LAST_UNSTABLE_BUILD);
        BUILTIN.add(LAST_UNSUCCESSFUL_BUILD);
        BUILTIN.add(LAST_COMPLETED_BUILD);
        PermalinkProjectAction.Permalink.LAST_STABLE_BUILD = LAST_STABLE_BUILD;
        PermalinkProjectAction.Permalink.LAST_SUCCESSFUL_BUILD = LAST_SUCCESSFUL_BUILD;
        PermalinkProjectAction.Permalink.LAST_FAILED_BUILD = LAST_FAILED_BUILD;
        PermalinkProjectAction.Permalink.LAST_UNSTABLE_BUILD = LAST_UNSTABLE_BUILD;
        PermalinkProjectAction.Permalink.LAST_UNSUCCESSFUL_BUILD = LAST_UNSUCCESSFUL_BUILD;
        PermalinkProjectAction.Permalink.LAST_COMPLETED_BUILD = LAST_COMPLETED_BUILD;
        LOGGER = Logger.getLogger(PeepholePermalink.class.getName());
    }

    @Restricted(value={Beta.class})
    public static interface Cache
    extends ExtensionPoint {
        public static final Unknown UNKNOWN = new Unknown();
        public static final None NONE = new None();

        @NonNull
        public PermalinkTarget get(@NonNull Job<?, ?> var1, @NonNull String var2);

        public void put(@NonNull Job<?, ?> var1, @NonNull String var2, @NonNull Known var3);

        public record Unknown() implements PermalinkTarget
        {
            @Override
            public Run<?, ?> resolve(PeepholePermalink pp, Job<?, ?> job, String id) {
                return this.search(pp, job, id, null);
            }
        }

        public record None() implements Known
        {
            @Override
            public Run<?, ?> resolve(PeepholePermalink pp, Job<?, ?> job, String id) {
                return null;
            }
        }

        public record Some(int number) implements Known
        {
            @Override
            public Run<?, ?> resolve(PeepholePermalink pp, Job<?, ?> job, String id) {
                Object b = job.getBuildByNumber(this.number);
                if (b != null && pp.apply((Run<?, ?>)b)) {
                    return b;
                }
                if (b == null) {
                    b = job.getNearestOldBuild(this.number);
                }
                return this.search(pp, job, id, (Run<?, ?>)b);
            }
        }

        public static sealed interface Known
        extends PermalinkTarget
        permits None, Some {
        }

        public static sealed interface PermalinkTarget
        extends Serializable
        permits Unknown, Known {
            @Restricted(value={NoExternalUse.class})
            @CheckForNull
            public Run<?, ?> resolve(@NonNull PeepholePermalink var1, @NonNull Job<?, ?> var2, @NonNull String var3);

            @Restricted(value={NoExternalUse.class})
            @CheckForNull
            default public Run<?, ?> search(@NonNull PeepholePermalink pp, @NonNull Job<?, ?> job, @NonNull String id, @CheckForNull Run<?, ?> b) {
                if (b == null) {
                    b = job.getLastBuild();
                }
                b = pp.find(b);
                pp.updateCache(job, b);
                return b;
            }
        }
    }

    @Extension
    public static class RunListenerImpl
    extends RunListener<Run<?, ?>> {
        @Override
        public void onDeleted(Run run) {
            Object j = run.getParent();
            for (PeepholePermalink pp : Util.filter(((Job)j).getPermalinks(), PeepholePermalink.class)) {
                if (pp.resolveNumber((Job<?, ?>)j) != run.number) continue;
                Run<?, ?> r = pp.find((Run<?, ?>)run.getPreviousBuild());
                LOGGER.fine(() -> "Updating " + pp.getId() + " permalink from deleted " + String.valueOf(run) + " to " + (r == null ? -1 : r.getNumber()));
                pp.updateCache((Job<?, ?>)j, r);
            }
        }

        @Override
        public void onCompleted(Run<?, ?> run, @NonNull TaskListener listener) {
            Object j = run.getParent();
            for (PeepholePermalink pp : Util.filter(((Job)j).getPermalinks(), PeepholePermalink.class)) {
                if (!pp.apply(run) || pp.resolveNumber((Job<?, ?>)j) >= run.getNumber()) continue;
                LOGGER.fine(() -> "Updating " + pp.getId() + " permalink to completed " + String.valueOf(run));
                pp.updateCache((Job<?, ?>)j, run);
            }
        }
    }

    @Restricted(value={NoExternalUse.class})
    @Extension(ordinal=-1000.0)
    public static final class DefaultCache
    implements Cache {
        private final Map<File, Map<String, Cache.Known>> caches = new HashMap<File, Map<String, Cache.Known>>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Cache.PermalinkTarget get(Job<?, ?> job, String id) {
            Map<String, Cache.Known> cache;
            Map<String, Cache.Known> map = cache = this.cacheFor(job.getBuildDir());
            synchronized (map) {
                Cache.Known cached = cache.get(id);
                return cached != null ? cached : UNKNOWN;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void put(Job<?, ?> job, String id, Cache.Known target) {
            Map<String, Cache.Known> cache;
            File buildDir = job.getBuildDir();
            Map<String, Cache.Known> map = cache = this.cacheFor(buildDir);
            synchronized (map) {
                cache.put(id, target);
                File storage = DefaultCache.storageFor(buildDir);
                LOGGER.fine(() -> "saving to " + String.valueOf(storage) + ": " + String.valueOf(cache));
                try (AtomicFileWriter cw = new AtomicFileWriter(storage);){
                    try {
                        for (Map.Entry<String, Cache.Known> entry : cache.entrySet()) {
                            int n;
                            cw.write(entry.getKey());
                            cw.write(32);
                            Cache.Known known = entry.getValue();
                            if (known instanceof Cache.Some) {
                                Cache.Some some = (Cache.Some)known;
                                n = some.number;
                            } else {
                                n = -1;
                            }
                            cw.write(Integer.toString(n));
                            cw.write(10);
                        }
                        cw.commit();
                    }
                    finally {
                        cw.abort();
                    }
                }
                catch (IOException x) {
                    LOGGER.log(Level.WARNING, "failed to update " + String.valueOf(storage), x);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NonNull
        private Map<String, Cache.Known> cacheFor(@NonNull File buildDir) {
            Map<File, Map<String, Cache.Known>> map = this.caches;
            synchronized (map) {
                Map<String, Cache.Known> cache = this.caches.get(buildDir);
                if (cache == null) {
                    cache = DefaultCache.load(buildDir);
                    this.caches.put(buildDir, cache);
                }
                return cache;
            }
        }

        @NonNull
        private static Map<String, Cache.Known> load(@NonNull File buildDir) {
            TreeMap<String, Cache.Known> cache = new TreeMap<String, Cache.Known>();
            File storage = DefaultCache.storageFor(buildDir);
            if (storage.isFile()) {
                try (Stream<String> lines = Files.lines(storage.toPath(), StandardCharsets.UTF_8);){
                    lines.forEach(line -> {
                        int idx = line.indexOf(32);
                        if (idx == -1) {
                            return;
                        }
                        try {
                            int number = Integer.parseInt(line.substring(idx + 1));
                            cache.put(line.substring(0, idx), (Cache.Known)((Object)(number == -1 ? Cache.NONE : new Cache.Some(number))));
                        }
                        catch (NumberFormatException x) {
                            LOGGER.log(Level.WARNING, "failed to read " + String.valueOf(storage), x);
                        }
                    });
                }
                catch (IOException x) {
                    LOGGER.log(Level.WARNING, "failed to read " + String.valueOf(storage), x);
                }
                LOGGER.fine(() -> "loading from " + String.valueOf(storage) + ": " + String.valueOf(cache));
            }
            return cache;
        }

        @NonNull
        static File storageFor(@NonNull File buildDir) {
            return new File(buildDir, "permalinks");
        }
    }
}

