/*
 * Decompiled with CFR 0.152.
 */
package jenkins.diagnostics;

import hudson.Extension;
import hudson.model.AdministrativeMonitor;
import java.io.IOException;
import jenkins.diagnostics.Messages;
import jenkins.model.Jenkins;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.interceptor.RequirePOST;

@Extension
@Symbol(value={"securityIsOff"})
public class SecurityIsOffMonitor
extends AdministrativeMonitor {
    @Override
    public String getDisplayName() {
        return Messages.SecurityIsOffMonitor_DisplayName();
    }

    @Override
    public boolean isActivated() {
        return !Jenkins.get().isUseSecurity();
    }

    @Override
    public boolean isSecurity() {
        return true;
    }

    @RequirePOST
    public void doAct(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException {
        if (req.hasParameter("no")) {
            this.disable(true);
            rsp.sendRedirect(req.getContextPath() + "/manage");
        } else {
            rsp.sendRedirect(req.getContextPath() + "/configureSecurity");
        }
    }
}

