/*
 * Decompiled with CFR 0.152.
 */
package hudson.util.jelly;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.jelly.JellyContext;
import org.apache.commons.jelly.JellyException;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.Tag;
import org.apache.commons.jelly.TagLibrary;
import org.apache.commons.jelly.XMLOutput;
import org.apache.commons.jelly.expression.Expression;
import org.apache.commons.jelly.impl.ExpressionAttribute;
import org.apache.commons.jelly.impl.TagScript;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class MorphTagLibrary
extends TagLibrary {
    private static final String META_ATTRIBUTES = "ATTRIBUTES";
    private static final String EXCEPT_ATTRIBUTES = "EXCEPT";

    public Tag createTag(String name, Attributes attributes) throws JellyException {
        return null;
    }

    public TagScript createTagScript(final String tagName, Attributes attributes) throws JellyException {
        return new TagScript(this){

            private Object evalAttribute(String name, JellyContext context) {
                ExpressionAttribute e = (ExpressionAttribute)this.attributes.get(name);
                if (e == null) {
                    return null;
                }
                return e.exp.evaluate(context);
            }

            private Collection<?> getExclusions(JellyContext context) {
                Object exclusion = this.evalAttribute(MorphTagLibrary.EXCEPT_ATTRIBUTES, context);
                if (exclusion == null) {
                    return Collections.emptySet();
                }
                if (exclusion instanceof String) {
                    return Arrays.asList(exclusion.toString().split("\\s+"));
                }
                if (exclusion instanceof Collection) {
                    return (Collection)exclusion;
                }
                throw new IllegalArgumentException("Expected collection for exclusion but found :" + String.valueOf(exclusion));
            }

            public void run(JellyContext context, XMLOutput output) throws JellyTagException {
                AttributesImpl actual = new AttributesImpl();
                Collection<?> exclusions = this.getExclusions(context);
                Map meta = (Map)this.evalAttribute(MorphTagLibrary.META_ATTRIBUTES, context);
                if (meta != null) {
                    for (Map.Entry e : meta.entrySet()) {
                        Object v;
                        String key = (String)e.getKey();
                        if (key.endsWith("Attr") && meta.containsKey(key.substring(0, key.length() - 4)) || key.equals("ownerTag") || exclusions.contains(key) || (v = e.getValue()) == null) continue;
                        actual.addAttribute("", key, key, "CDATA", v.toString());
                    }
                } else {
                    meta = Collections.emptyMap();
                }
                for (Map.Entry e : this.attributes.entrySet()) {
                    int idx;
                    String name = (String)e.getKey();
                    if (name.equals(MorphTagLibrary.META_ATTRIBUTES) || name.equals(MorphTagLibrary.EXCEPT_ATTRIBUTES)) continue;
                    if (meta.containsKey(name) && (idx = actual.getIndex(name)) >= 0) {
                        actual.removeAttribute(idx);
                    }
                    Expression expression = ((ExpressionAttribute)e.getValue()).exp;
                    actual.addAttribute("", name, name, "CDATA", expression.evaluateAsString(context));
                }
                try {
                    output.startElement(tagName, (Attributes)actual);
                    this.getTagBody().run(context, output);
                    output.endElement(tagName);
                }
                catch (SAXException x) {
                    throw new JellyTagException((Throwable)x);
                }
            }
        };
    }
}

