/*
 * Decompiled with CFR 0.152.
 */
package hudson.util;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;

public class TagCloud<T>
extends AbstractList<Entry> {
    private final List<Entry> entries = new ArrayList<Entry>();
    private float max = 1.0f;

    public TagCloud(Iterable<? extends T> inputs, WeightFunction<T> f) {
        for (T input : inputs) {
            float w = Math.abs(f.weight(input));
            this.max = Math.max(w, this.max);
            this.entries.add(new Entry(input, w));
        }
    }

    @Override
    public Entry get(int index) {
        return this.entries.get(index);
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    public static interface WeightFunction<T> {
        public float weight(T var1);
    }

    public final class Entry {
        public final T item;
        public final float weight;

        public Entry(T item, float weight) {
            this.item = item;
            this.weight = weight;
        }

        public float scale() {
            return this.weight * 9.0f / TagCloud.this.max;
        }

        public String getClassName() {
            return "tag" + (int)this.scale();
        }
    }
}

