/*
 * Decompiled with CFR 0.152.
 */
package hudson.tasks;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Job;
import hudson.model.Run;
import java.io.IOException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import jenkins.model.BuildDiscarder;
import jenkins.model.BuildDiscarderDescriptor;
import jenkins.util.io.CompositeIOException;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class LogRotator
extends BuildDiscarder {
    private final int daysToKeep;
    private final int numToKeep;
    private final Integer artifactDaysToKeep;
    private final Integer artifactNumToKeep;
    private boolean removeLastBuild;
    private static final Logger LOGGER = Logger.getLogger(LogRotator.class.getName());

    @DataBoundConstructor
    public LogRotator(String daysToKeepStr, String numToKeepStr, String artifactDaysToKeepStr, String artifactNumToKeepStr) {
        this(LogRotator.parse(daysToKeepStr), LogRotator.parse(numToKeepStr), LogRotator.parse(artifactDaysToKeepStr), LogRotator.parse(artifactNumToKeepStr));
    }

    public static int parse(String p) {
        if (p == null) {
            return -1;
        }
        try {
            return Integer.parseInt(p);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    @Deprecated
    public LogRotator(int daysToKeep, int numToKeep) {
        this(daysToKeep, numToKeep, -1, -1);
    }

    public LogRotator(int daysToKeep, int numToKeep, int artifactDaysToKeep, int artifactNumToKeep) {
        this.daysToKeep = daysToKeep;
        this.numToKeep = numToKeep;
        this.artifactDaysToKeep = artifactDaysToKeep;
        this.artifactNumToKeep = artifactNumToKeep;
    }

    @DataBoundSetter
    public void setRemoveLastBuild(boolean removeLastBuild) {
        this.removeLastBuild = removeLastBuild;
    }

    @Override
    public void perform(Job<?, ?> job) throws IOException, InterruptedException {
        Object r2;
        GregorianCalendar cal;
        Run lstb;
        HashMap<Run, Set> exceptionMap = new HashMap<Run, Set>();
        LOGGER.log(Level.FINE, "Running the log rotation for {0} with numToKeep={1} daysToKeep={2} artifactNumToKeep={3} artifactDaysToKeep={4}", new Object[]{job, this.numToKeep, this.daysToKeep, this.artifactNumToKeep, this.artifactDaysToKeep});
        Run lsb = this.removeLastBuild ? null : (Run)job.getLastSuccessfulBuild();
        Run run = lstb = this.removeLastBuild ? null : (Run)job.getLastStableBuild();
        if (this.numToKeep != -1) {
            job.getBuildsAsMap().entrySet().stream().skip(this.numToKeep).map(Map.Entry::getValue).filter(r -> !this.shouldKeepRun((Run)r, lsb, lstb)).forEach(r -> {
                LOGGER.log(Level.FINE, "{0} is to be removed", r);
                try {
                    r.delete();
                }
                catch (IOException ex) {
                    exceptionMap.computeIfAbsent((Run)r, key -> new HashSet()).add(ex);
                }
            });
        }
        if (this.daysToKeep != -1) {
            cal = new GregorianCalendar();
            ((Calendar)cal).add(6, -this.daysToKeep);
            for (r2 = job.getFirstBuild(); r2 != null && !this.tooNew((Run)r2, cal); r2 = ((Run)r2).getNextBuild()) {
                if (this.shouldKeepRun((Run)r2, lsb, lstb)) continue;
                LOGGER.log(Level.FINE, "{0} is to be removed", r2);
                try {
                    ((Run)r2).delete();
                    continue;
                }
                catch (IOException ex) {
                    exceptionMap.computeIfAbsent((Run)r2, key -> new HashSet()).add(ex);
                }
            }
        }
        if (this.artifactNumToKeep != null && this.artifactNumToKeep != -1) {
            job.getBuildsAsMap().entrySet().stream().skip(this.artifactNumToKeep.intValue()).map(Map.Entry::getValue).filter(r -> !this.shouldKeepRun((Run)r, lsb, lstb)).forEach(r -> {
                LOGGER.log(Level.FINE, "{0} is to be purged of artifacts", r);
                try {
                    r.deleteArtifacts();
                }
                catch (IOException ex) {
                    exceptionMap.computeIfAbsent((Run)r, key -> new HashSet()).add(ex);
                }
            });
        }
        if (this.artifactDaysToKeep != null && this.artifactDaysToKeep != -1) {
            cal = new GregorianCalendar();
            ((Calendar)cal).add(6, -this.artifactDaysToKeep.intValue());
            for (r2 = job.getFirstBuild(); r2 != null && !this.tooNew((Run)r2, cal); r2 = ((Run)r2).getNextBuild()) {
                if (this.shouldKeepRun((Run)r2, lsb, lstb)) continue;
                LOGGER.log(Level.FINE, "{0} is to be purged of artifacts", r2);
                try {
                    ((Run)r2).deleteArtifacts();
                    continue;
                }
                catch (IOException ex) {
                    exceptionMap.computeIfAbsent((Run)r2, key -> new HashSet()).add(ex);
                }
            }
        }
        if (!exceptionMap.isEmpty()) {
            String msg = String.format("Failed to rotate logs for [%s]", exceptionMap.keySet().stream().map(Object::toString).collect(Collectors.joining(", ")));
            throw new CompositeIOException(msg, exceptionMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList()));
        }
    }

    private boolean shouldKeepRun(Run r, Run lsb, Run lstb) {
        if (r.isKeepLog()) {
            LOGGER.log(Level.FINER, "{0} is not to be removed or purged of artifacts because it\u2019s marked as a keeper", r);
            return true;
        }
        if (r == lsb) {
            LOGGER.log(Level.FINER, "{0} is not to be removed or purged of artifacts because it\u2019s the last successful build", r);
            return true;
        }
        if (r == lstb) {
            LOGGER.log(Level.FINER, "{0} is not to be removed or purged of artifacts because it\u2019s the last stable build", r);
            return true;
        }
        if (r.isLogUpdated()) {
            LOGGER.log(Level.FINER, "{0} is not to be removed or purged of artifacts because it\u2019s still building", r);
            return true;
        }
        return false;
    }

    private boolean tooNew(Run r, Calendar cal) {
        if (!r.getTimestamp().before(cal)) {
            LOGGER.log(Level.FINER, "{0} is not to be removed or purged of artifacts because it\u2019s still new", r);
            return true;
        }
        return false;
    }

    public int getDaysToKeep() {
        return this.daysToKeep;
    }

    public int getNumToKeep() {
        return this.numToKeep;
    }

    public int getArtifactDaysToKeep() {
        return this.unbox(this.artifactDaysToKeep);
    }

    public int getArtifactNumToKeep() {
        return this.unbox(this.artifactNumToKeep);
    }

    public boolean isRemoveLastBuild() {
        return this.removeLastBuild;
    }

    public String getDaysToKeepStr() {
        return this.toString(this.daysToKeep);
    }

    public String getNumToKeepStr() {
        return this.toString(this.numToKeep);
    }

    public String getArtifactDaysToKeepStr() {
        return this.toString(this.artifactDaysToKeep);
    }

    public String getArtifactNumToKeepStr() {
        return this.toString(this.artifactNumToKeep);
    }

    private int unbox(Integer i) {
        return i == null ? -1 : i;
    }

    private String toString(Integer i) {
        if (i == null || i == -1) {
            return "";
        }
        return String.valueOf(i);
    }

    @Extension
    @Symbol(value={"logRotator"})
    public static final class LRDescriptor
    extends BuildDiscarderDescriptor {
        @Override
        @NonNull
        public String getDisplayName() {
            return "Log Rotation";
        }
    }

    @Deprecated
    public static class CollatedLogRotatorException
    extends IOException {
        private static final long serialVersionUID = 5944233808072651101L;
        public final Collection<Exception> collated;

        public CollatedLogRotatorException(String msg, Exception ... collated) {
            super(msg);
            this.collated = collated == null || collated.length == 0 ? Collections.emptyList() : Arrays.asList(collated);
        }

        public CollatedLogRotatorException(String msg, Collection<Exception> values) {
            super(msg);
            this.collated = values != null ? values : Collections.emptyList();
        }
    }
}

