/*
 * Decompiled with CFR 0.152.
 */
package hudson.slaves;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.AbortException;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.model.Computer;
import hudson.model.Label;
import hudson.model.LoadStatistics;
import hudson.model.MultiStageTimeSeries;
import hudson.model.Node;
import hudson.model.PeriodicWork;
import hudson.slaves.Cloud;
import hudson.slaves.CloudProvisioningListener;
import hudson.slaves.Messages;
import java.awt.Color;
import java.io.IOException;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.util.SystemProperties;
import jenkins.util.Timer;
import net.jcip.annotations.GuardedBy;
import org.jenkinsci.Symbol;

public class NodeProvisioner {
    private final LoadStatistics stat;
    @CheckForNull
    private final Label label;
    private final AtomicReference<List<PlannedNode>> pendingLaunches = new AtomicReference(new ArrayList());
    private final Lock provisioningLock = new ReentrantLock();
    @GuardedBy(value="provisioningLock")
    private StrategyState provisioningState = null;
    private volatile transient long lastSuggestedReview;
    private volatile transient boolean queuedReview;
    private final MultiStageTimeSeries plannedCapacitiesEMA = new MultiStageTimeSeries(Messages._NodeProvisioner_EmptyString(), Color.WHITE, 0.0f, LoadStatistics.DECAY);
    private static final Logger LOGGER = Logger.getLogger(NodeProvisioner.class.getName());
    private static final float MARGIN = (float)SystemProperties.getInteger(NodeProvisioner.class.getName() + ".MARGIN", 10).intValue() / 100.0f;
    private static final float MARGIN0 = Math.max(MARGIN, NodeProvisioner.getFloatSystemProperty(NodeProvisioner.class.getName() + ".MARGIN0", 0.5f));
    private static final float MARGIN_DECAY = NodeProvisioner.getFloatSystemProperty(NodeProvisioner.class.getName() + ".MARGIN_DECAY", 0.5f);
    private static final MultiStageTimeSeries.TimeScale TIME_SCALE = MultiStageTimeSeries.TimeScale.SEC10;

    public NodeProvisioner(@CheckForNull Label label, LoadStatistics loadStatistics) {
        this.label = label;
        this.stat = loadStatistics;
    }

    public List<PlannedNode> getPendingLaunches() {
        return new ArrayList<PlannedNode>((Collection)this.pendingLaunches.get());
    }

    public void suggestReviewNow() {
        if (!this.queuedReview) {
            long delay = TimeUnit.SECONDS.toMillis(1L) - (System.currentTimeMillis() - this.lastSuggestedReview);
            if (delay < 0L) {
                this.lastSuggestedReview = System.currentTimeMillis();
                Computer.threadPoolForRemoting.submit(() -> {
                    LOGGER.fine(() -> "running suggested review for " + String.valueOf(this.label));
                    this.update();
                });
            } else {
                this.queuedReview = true;
                LOGGER.fine(() -> "running suggested review in " + delay + " ms for " + String.valueOf(this.label));
                Timer.get().schedule(() -> {
                    this.lastSuggestedReview = System.currentTimeMillis();
                    LOGGER.fine(() -> "running suggested review for " + String.valueOf(this.label) + " after " + delay + " ms");
                    this.update();
                }, delay, TimeUnit.MILLISECONDS);
            }
        } else {
            LOGGER.fine(() -> "ignoring suggested review for " + String.valueOf(this.label));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update() {
        long start;
        block23: {
            start = LOGGER.isLoggable(Level.FINER) ? System.nanoTime() : 0L;
            this.provisioningLock.lock();
            try {
                this.lastSuggestedReview = System.currentTimeMillis();
                this.queuedReview = false;
                Jenkins jenkins = Jenkins.get();
                int plannedCapacitySnapshot = 0;
                ArrayList snapPendingLaunches = new ArrayList(this.pendingLaunches.get());
                for (PlannedNode f : snapPendingLaunches) {
                    if (f.future.isDone()) {
                        try {
                            Node node = null;
                            try {
                                node = f.future.get();
                            }
                            catch (InterruptedException e) {
                                throw new AssertionError("InterruptedException occurred", e);
                            }
                            catch (ExecutionException e) {
                                Throwable cause = e.getCause();
                                if (!(cause instanceof AbortException)) {
                                    LOGGER.log(Level.WARNING, "Unexpected exception encountered while provisioning agent " + f.displayName, cause);
                                }
                                NodeProvisioner.fireOnFailure(f, cause);
                            }
                            if (node == null) continue;
                            NodeProvisioner.fireOnComplete(f, node);
                            try {
                                jenkins.addNode(node);
                                LOGGER.log(Level.INFO, "{0} provisioning successfully completed. We have now {1,number,integer} computer(s)", new Object[]{f.displayName, jenkins.getComputersCollection().size()});
                                NodeProvisioner.fireOnCommit(f, node);
                            }
                            catch (IOException e) {
                                LOGGER.log(Level.WARNING, "Provisioned agent " + f.displayName + " failed to launch", e);
                                NodeProvisioner.fireOnRollback(f, node, e);
                            }
                            continue;
                        }
                        catch (Error e) {
                            throw e;
                        }
                        catch (Throwable e) {
                            LOGGER.log(Level.SEVERE, "Unexpected uncaught exception encountered while processing agent " + f.displayName, e);
                            continue;
                        }
                        finally {
                            ArrayList<PlannedNode> repl;
                            List<PlannedNode> orig;
                            boolean changed;
                            block15: do {
                                orig = this.pendingLaunches.get();
                                repl = new ArrayList<PlannedNode>(orig);
                                changed = false;
                                Iterator iterator = repl.iterator();
                                while (iterator.hasNext()) {
                                    PlannedNode p = (PlannedNode)iterator.next();
                                    if (p != f) continue;
                                    iterator.remove();
                                    changed = true;
                                    continue block15;
                                }
                            } while (changed && !this.pendingLaunches.compareAndSet(orig, repl));
                            f.spent();
                            continue;
                        }
                    }
                    plannedCapacitySnapshot += f.numExecutors;
                }
                float plannedCapacity = plannedCapacitySnapshot;
                this.plannedCapacitiesEMA.update(plannedCapacity);
                LoadStatistics.LoadStatisticsSnapshot snapshot = this.stat.computeSnapshot();
                int availableSnapshot = snapshot.getAvailableExecutors();
                int queueLengthSnapshot = snapshot.getQueueLength();
                if (queueLengthSnapshot <= availableSnapshot) {
                    LOGGER.log(Level.FINER, "Queue length {0} is less than the available capacity {1}. No provisioning strategy required", new Object[]{queueLengthSnapshot, availableSnapshot});
                    this.provisioningState = null;
                } else {
                    this.provisioningState = new StrategyState(snapshot, this.label, plannedCapacitySnapshot);
                }
                if (this.provisioningState == null) break block23;
                ExtensionList<Strategy> strategies = Jenkins.get().getExtensionList(Strategy.class);
                for (Strategy strategy : strategies.isEmpty() ? List.of(new StandardStrategyImpl()) : strategies) {
                    LOGGER.log(Level.FINER, "Consulting {0} provisioning strategy with state {1}", new Object[]{strategy, this.provisioningState});
                    if (StrategyDecision.PROVISIONING_COMPLETED != strategy.apply(this.provisioningState)) continue;
                    LOGGER.log(Level.FINER, "Provisioning strategy {0} declared provisioning complete", strategy);
                    break;
                }
            }
            finally {
                this.provisioningLock.unlock();
            }
        }
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer(() -> "ran update on " + String.valueOf(this.label) + " in " + (System.nanoTime() - start) / 1000000L + "ms");
        }
    }

    private static float getFloatSystemProperty(String propName, float defaultValue) {
        String v = SystemProperties.getString(propName);
        if (v != null) {
            try {
                return Float.parseFloat(v);
            }
            catch (NumberFormatException e) {
                LOGGER.warning("Failed to parse a float value from system property " + propName + ". value was " + v);
            }
        }
        return defaultValue;
    }

    private static void fireOnFailure(PlannedNode plannedNode, Throwable cause) {
        for (CloudProvisioningListener cl : CloudProvisioningListener.all()) {
            try {
                cl.onFailure(plannedNode, cause);
            }
            catch (Error e) {
                throw e;
            }
            catch (Throwable e) {
                LOGGER.log(Level.SEVERE, "Unexpected uncaught exception encountered while processing onFailure() listener call in " + String.valueOf(cl) + " for agent " + plannedNode.displayName, e);
            }
        }
    }

    private static void fireOnRollback(PlannedNode plannedNode, Node newNode, Throwable cause) {
        for (CloudProvisioningListener cl : CloudProvisioningListener.all()) {
            try {
                cl.onRollback(plannedNode, newNode, cause);
            }
            catch (Error e) {
                throw e;
            }
            catch (Throwable e) {
                LOGGER.log(Level.SEVERE, "Unexpected uncaught exception encountered while processing onRollback() listener call in " + String.valueOf(cl) + " for agent " + newNode.getDisplayName(), e);
            }
        }
    }

    private static void fireOnComplete(PlannedNode plannedNode, Node newNode) {
        for (CloudProvisioningListener cl : CloudProvisioningListener.all()) {
            try {
                cl.onComplete(plannedNode, newNode);
            }
            catch (Error e) {
                throw e;
            }
            catch (Throwable e) {
                LOGGER.log(Level.SEVERE, "Unexpected uncaught exception encountered while processing onComplete() listener call in " + String.valueOf(cl) + " for agent " + plannedNode.displayName, e);
            }
        }
    }

    private static void fireOnCommit(PlannedNode plannedNode, Node newNode) {
        for (CloudProvisioningListener cl : CloudProvisioningListener.all()) {
            try {
                cl.onCommit(plannedNode, newNode);
            }
            catch (Error e) {
                throw e;
            }
            catch (Throwable e) {
                LOGGER.log(Level.SEVERE, "Unexpected uncaught exception encountered while processing onCommit() listener call in " + String.valueOf(cl) + " for agent " + newNode.getDisplayName(), e);
            }
        }
    }

    private static void fireOnStarted(Cloud cloud, Label label, Collection<PlannedNode> plannedNodes) {
        for (CloudProvisioningListener cl : CloudProvisioningListener.all()) {
            try {
                cl.onStarted(cloud, label, plannedNodes);
            }
            catch (Error e) {
                throw e;
            }
            catch (Throwable e) {
                LOGGER.log(Level.SEVERE, "Unexpected uncaught exception encountered while processing onStarted() listener call in " + String.valueOf(cl) + " for label " + label.toString(), e);
            }
        }
    }

    public final class StrategyState {
        @CheckForNull
        private final Label label;
        private final int plannedCapacitySnapshot;
        private final LoadStatistics.LoadStatisticsSnapshot snapshot;
        @GuardedBy(value="this")
        private int additionalPlannedCapacity;

        private StrategyState(@CheckForNull LoadStatistics.LoadStatisticsSnapshot snapshot, Label label, int plannedCapacitySnapshot) {
            this.snapshot = snapshot;
            this.label = label;
            this.plannedCapacitySnapshot = plannedCapacitySnapshot;
        }

        @CheckForNull
        public Label getLabel() {
            return this.label;
        }

        public LoadStatistics.LoadStatisticsSnapshot getSnapshot() {
            return this.snapshot;
        }

        @Deprecated
        public int getQueueLengthSnapshot() {
            return this.snapshot.getQueueLength();
        }

        public int getPlannedCapacitySnapshot() {
            return this.plannedCapacitySnapshot;
        }

        @Deprecated
        public int getIdleSnapshot() {
            return this.snapshot.getAvailableExecutors();
        }

        @Deprecated
        public int getTotalSnapshot() {
            return this.snapshot.getOnlineExecutors();
        }

        public synchronized int getAdditionalPlannedCapacity() {
            return this.additionalPlannedCapacity;
        }

        public float getQueueLengthLatest() {
            return NodeProvisioner.this.stat.queueLength.getLatest(TIME_SCALE);
        }

        public float getPlannedCapacityLatest() {
            return NodeProvisioner.this.plannedCapacitiesEMA.getLatest(TIME_SCALE);
        }

        @Deprecated
        public float getIdleLatest() {
            return this.getAvailableExecutorsLatest();
        }

        @Deprecated
        public float getTotalLatest() {
            return this.getOnlineExecutorsLatest();
        }

        public float getDefinedExecutorsLatest() {
            return NodeProvisioner.this.stat.definedExecutors.getLatest(TIME_SCALE);
        }

        public float getOnlineExecutorsLatest() {
            return NodeProvisioner.this.stat.onlineExecutors.getLatest(TIME_SCALE);
        }

        public float getConnectingExecutorsLatest() {
            return NodeProvisioner.this.stat.connectingExecutors.getLatest(TIME_SCALE);
        }

        public float getBusyExecutorsLatest() {
            return NodeProvisioner.this.stat.busyExecutors.getLatest(TIME_SCALE);
        }

        public float getIdleExecutorsLatest() {
            return NodeProvisioner.this.stat.idleExecutors.getLatest(TIME_SCALE);
        }

        public float getAvailableExecutorsLatest() {
            return NodeProvisioner.this.stat.availableExecutors.getLatest(TIME_SCALE);
        }

        public void recordPendingLaunches(PlannedNode ... plannedNodes) {
            this.recordPendingLaunches(Arrays.asList(plannedNodes));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void recordPendingLaunches(Collection<PlannedNode> plannedNodes) {
            int additionalPlannedCapacity = 0;
            for (PlannedNode f : plannedNodes) {
                if (f.future.isDone()) {
                    try {
                        Node node = f.future.get();
                        if (node == null) continue;
                        additionalPlannedCapacity += node.getNumExecutors();
                    }
                    catch (InterruptedException | ExecutionException exception) {}
                    continue;
                }
                additionalPlannedCapacity += f.numExecutors;
            }
            while (!plannedNodes.isEmpty()) {
                List<PlannedNode> orig = NodeProvisioner.this.pendingLaunches.get();
                ArrayList<PlannedNode> repl = new ArrayList<PlannedNode>(orig);
                repl.addAll(plannedNodes);
                if (!NodeProvisioner.this.pendingLaunches.compareAndSet(orig, repl)) continue;
                if (additionalPlannedCapacity <= 0) break;
                StrategyState strategyState = this;
                synchronized (strategyState) {
                    this.additionalPlannedCapacity += additionalPlannedCapacity;
                    break;
                }
            }
        }

        public String toString() {
            String sb = "StrategyState{label=" + String.valueOf(this.label) + ", snapshot=" + String.valueOf(this.snapshot) + ", plannedCapacitySnapshot=" + this.plannedCapacitySnapshot + ", additionalPlannedCapacity=" + this.additionalPlannedCapacity + "}";
            return sb;
        }
    }

    public static class PlannedNode {
        public final String displayName;
        public final Future<Node> future;
        public final int numExecutors;

        public PlannedNode(String displayName, Future<Node> future, int numExecutors) {
            if (displayName == null || future == null || numExecutors < 1) {
                throw new IllegalArgumentException();
            }
            this.displayName = displayName;
            this.future = future;
            this.numExecutors = numExecutors;
        }

        public void spent() {
        }
    }

    public static abstract class Strategy
    implements ExtensionPoint {
        @GuardedBy(value="NodeProvisioner.this")
        @NonNull
        public abstract StrategyDecision apply(@NonNull StrategyState var1);
    }

    @Extension
    @Symbol(value={"standard"})
    public static class StandardStrategyImpl
    extends Strategy {
        @Override
        @NonNull
        public StrategyDecision apply(@NonNull StrategyState state) {
            LoadStatistics.LoadStatisticsSnapshot snapshot = state.getSnapshot();
            boolean needSomeWhenNoneAtAll = snapshot.getAvailableExecutors() + snapshot.getConnectingExecutors() == 0 && snapshot.getOnlineExecutors() + state.getPlannedCapacitySnapshot() + state.getAdditionalPlannedCapacity() == 0 && snapshot.getQueueLength() > 0;
            float available = Math.max((float)snapshot.getAvailableExecutors(), state.getAvailableExecutorsLatest());
            if (available < MARGIN || needSomeWhenNoneAtAll) {
                float m;
                float qlen = Math.min(state.getQueueLengthLatest(), (float)snapshot.getQueueLength());
                float connectingCapacity = Math.min(state.getConnectingExecutorsLatest(), (float)snapshot.getConnectingExecutors());
                float plannedCapacity = Math.max(state.getPlannedCapacityLatest(), (float)state.getPlannedCapacitySnapshot()) + (float)state.getAdditionalPlannedCapacity();
                float excessWorkload = qlen - plannedCapacity - connectingCapacity;
                if (needSomeWhenNoneAtAll && excessWorkload < 1.0f) {
                    excessWorkload = 1.0f;
                }
                if (excessWorkload > 1.0f - (m = this.calcThresholdMargin(state.getTotalSnapshot()))) {
                    LOGGER.log(Level.FINE, "Excess workload {0,number,#.###} detected. (planned capacity={1,number,#.###},connecting capacity={7,number,#.###},Qlen={2,number,#.###},available={3,number,#.###}&{4,number,integer},online={5,number,integer},m={6,number,#.###})", new Object[]{Float.valueOf(excessWorkload), Float.valueOf(plannedCapacity), Float.valueOf(qlen), Float.valueOf(available), snapshot.getAvailableExecutors(), snapshot.getOnlineExecutors(), Float.valueOf(m), snapshot.getConnectingExecutors()});
                    block0: for (Cloud c : Jenkins.get().clouds) {
                        if (excessWorkload < 0.0f) break;
                        Cloud.CloudState cloudState = new Cloud.CloudState(state.getLabel(), state.getAdditionalPlannedCapacity());
                        if (!c.canProvision(cloudState)) continue;
                        int workloadToProvision = (int)Math.round(Math.floor(excessWorkload + m));
                        for (CloudProvisioningListener cl : CloudProvisioningListener.all()) {
                            if (cl.canProvision(c, cloudState, workloadToProvision) == null) continue;
                            continue block0;
                        }
                        Collection<PlannedNode> additionalCapacities = c.provision(cloudState, workloadToProvision);
                        NodeProvisioner.fireOnStarted(c, state.getLabel(), additionalCapacities);
                        for (PlannedNode ac : additionalCapacities) {
                            LOGGER.log(Level.INFO, "Started provisioning {0} from {1} with {2,number,integer} executors. Remaining excess workload: {3,number,#.###}", new Object[]{ac.displayName, c.name, ac.numExecutors, Float.valueOf(excessWorkload -= (float)ac.numExecutors)});
                        }
                        state.recordPendingLaunches(additionalCapacities);
                    }
                    return excessWorkload > 1.0f - m ? StrategyDecision.CONSULT_REMAINING_STRATEGIES : StrategyDecision.PROVISIONING_COMPLETED;
                }
            }
            return StrategyDecision.CONSULT_REMAINING_STRATEGIES;
        }

        private float calcThresholdMargin(int totalSnapshot) {
            float f = (float)((double)MARGIN + (double)(MARGIN0 - MARGIN) * Math.pow(MARGIN_DECAY, totalSnapshot));
            f = Math.max(f, 0.0f);
            f = Math.min(f, 1.0f);
            return f;
        }
    }

    public static enum StrategyDecision {
        CONSULT_REMAINING_STRATEGIES,
        PROVISIONING_COMPLETED;

    }

    @Extension
    public static class NodeProvisionerInvoker
    extends PeriodicWork {
        @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="for script console")
        public static int INITIALDELAY = (int)SystemProperties.getDuration(NodeProvisioner.class.getName() + ".initialDelay", ChronoUnit.MILLIS, Duration.ofMillis((long)LoadStatistics.CLOCK * 10L)).toMillis();
        @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="for script console")
        public static int RECURRENCEPERIOD = (int)SystemProperties.getDuration(NodeProvisioner.class.getName() + ".recurrencePeriod", ChronoUnit.MILLIS, Duration.ofMillis(LoadStatistics.CLOCK)).toMillis();

        @Override
        public long getInitialDelay() {
            return INITIALDELAY;
        }

        @Override
        public long getRecurrencePeriod() {
            return RECURRENCEPERIOD;
        }

        @Override
        protected void doRun() {
            Jenkins j = Jenkins.get();
            j.unlabeledNodeProvisioner.update();
            for (Label l : j.getLabels()) {
                l.nodeProvisioner.update();
            }
        }
    }
}

