/*
 * Decompiled with CFR 0.152.
 */
package hudson.security;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Functions;
import hudson.model.Api;
import hudson.model.UnprotectedRootAction;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Set;
import jenkins.model.Jenkins;
import jenkins.util.MemoryReductionUtil;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;

@Extension
@Symbol(value={"whoAmI"})
@ExportedBean
public class WhoAmI
implements UnprotectedRootAction {
    private static final Set<String> dangerousHeaders = Set.of("cookie", "authorization", "www-authenticate", "proxy-authenticate", "proxy-authorization");

    public Api getApi() {
        return new Api(this);
    }

    @Exported
    public String getName() {
        return this.auth().getName();
    }

    @Exported
    public boolean isAuthenticated() {
        return this.auth().isAuthenticated();
    }

    @Exported
    public boolean isAnonymous() {
        return Functions.isAnonymous();
    }

    public String getDetails() {
        return this.auth().getDetails() != null ? this.auth().getDetails().toString() : null;
    }

    public String getToString() {
        return this.auth().toString();
    }

    @NonNull
    private Authentication auth() {
        return Jenkins.getAuthentication2();
    }

    @Exported
    public String[] getAuthorities() {
        if (this.auth().getAuthorities() == null) {
            return MemoryReductionUtil.EMPTY_STRING_ARRAY;
        }
        ArrayList<String> authorities = new ArrayList<String>();
        for (GrantedAuthority a : this.auth().getAuthorities()) {
            authorities.add(a.getAuthority());
        }
        return authorities.toArray(new String[0]);
    }

    @Restricted(value={NoExternalUse.class})
    public boolean isHeaderDangerous(@NonNull String name) {
        return dangerousHeaders.contains(name.toLowerCase(Locale.ENGLISH));
    }

    @Override
    public String getIconFileName() {
        return null;
    }

    @Override
    public String getDisplayName() {
        return "Who Am I";
    }

    @Override
    public String getUrlName() {
        return "whoAmI";
    }
}

