/*
 * Decompiled with CFR 0.152.
 */
package hudson.security;

import hudson.security.Messages;
import hudson.security.UserMayOrMayNotExistException2;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

@Restricted(value={NoExternalUse.class})
public class UserDetailsServiceProxy
implements UserDetailsService {
    private volatile UserDetailsService delegate;

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        UserDetailsService uds = this.delegate;
        if (uds == null) {
            throw new UserMayOrMayNotExistException2(Messages.UserDetailsServiceProxy_UnableToQuery(username));
        }
        return uds.loadUserByUsername(username);
    }

    public void setDelegate(UserDetailsService core) {
        this.delegate = core;
    }
}

