/*
 * Decompiled with CFR 0.152.
 */
package hudson.security;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.security.ACL;
import hudson.security.AuthorizationStrategy;
import hudson.security.Messages;
import hudson.security.Permission;
import hudson.security.SparseACL;
import java.util.Collection;
import java.util.Set;
import jenkins.model.Jenkins;
import org.acegisecurity.acls.sid.GrantedAuthoritySid;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;

public final class LegacyAuthorizationStrategy
extends AuthorizationStrategy {
    private static final ACL LEGACY_ACL = new SparseACL(null){
        {
            this.add(EVERYONE, Permission.READ, true);
            this.add(new GrantedAuthoritySid("admin"), Jenkins.ADMINISTER, true);
        }
    };

    @DataBoundConstructor
    public LegacyAuthorizationStrategy() {
    }

    @Override
    public ACL getRootACL() {
        return LEGACY_ACL;
    }

    @Override
    public Collection<String> getGroups() {
        return Set.of("admin");
    }

    @Extension
    @Symbol(value={"legacy"})
    public static final class DescriptorImpl
    extends Descriptor<AuthorizationStrategy> {
        @Override
        @NonNull
        public String getDisplayName() {
            return Messages.LegacyAuthorizationStrategy_DisplayName();
        }
    }
}

