/*
 * Decompiled with CFR 0.152.
 */
package hudson.search;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.ExtensionComponent;
import hudson.ExtensionList;
import hudson.Util;
import hudson.search.SearchIndex;
import hudson.search.SearchIndexBuilder;
import hudson.search.SearchItem;
import hudson.search.SearchResult;
import hudson.search.SearchableModelObject;
import hudson.search.SuggestedItem;
import hudson.util.EditDistance;
import io.jenkins.servlet.ServletExceptionWrapper;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import jenkins.search.SearchGroup;
import jenkins.security.stapler.StaplerNotDispatchable;
import jenkins.util.MemoryReductionUtil;
import jenkins.util.SystemProperties;
import org.jenkins.ui.symbol.Symbol;
import org.jenkins.ui.symbol.SymbolRequest;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.Ancestor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerProxy;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.export.DataWriter;
import org.kohsuke.stapler.export.ExportConfig;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;
import org.kohsuke.stapler.export.Flavor;

public class Search
implements StaplerProxy {
    private static int MAX_SEARCH_SIZE = Integer.getInteger(Search.class.getName() + ".MAX_SEARCH_SIZE", 500);
    @Restricted(value={NoExternalUse.class})
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="for script console")
    public static boolean SKIP_PERMISSION_CHECK = SystemProperties.getBoolean(Search.class.getName() + ".skipPermissionCheck");
    private static final Logger LOGGER = Logger.getLogger(Search.class.getName());

    public void doIndex(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, jakarta.servlet.ServletException {
        if (Util.isOverridden(Search.class, this.getClass(), "doIndex", StaplerRequest.class, StaplerResponse.class)) {
            try {
                this.doIndex(StaplerRequest.fromStaplerRequest2((StaplerRequest2)req), StaplerResponse.fromStaplerResponse2((StaplerResponse2)rsp));
            }
            catch (ServletException e) {
                throw ServletExceptionWrapper.toJakartaServletException((ServletException)e);
            }
        } else {
            this.doIndexImpl(req, rsp);
        }
    }

    @Deprecated
    @StaplerNotDispatchable
    public void doIndex(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        try {
            this.doIndexImpl(StaplerRequest.toStaplerRequest2((StaplerRequest)req), StaplerResponse.toStaplerResponse2((StaplerResponse)rsp));
        }
        catch (jakarta.servlet.ServletException e) {
            throw ServletExceptionWrapper.fromJakartaServletException((jakarta.servlet.ServletException)e);
        }
    }

    private void doIndexImpl(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, jakarta.servlet.ServletException {
        List l = req.getAncestors();
        for (int i = l.size() - 1; i >= 0; --i) {
            SuggestedItem target;
            Ancestor a = (Ancestor)l.get(i);
            if (!(a.getObject() instanceof SearchableModelObject)) continue;
            SearchableModelObject smo = (SearchableModelObject)a.getObject();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(String.format("smo.displayName=%s, searchName=%s", smo.getDisplayName(), smo.getSearchName()));
            }
            SearchIndex index = smo.getSearchIndex();
            String query = req.getParameter("q");
            if (query == null || (target = Search.find(index, query, smo)) == null) continue;
            rsp.sendRedirect2(req.getContextPath() + target.getUrl());
            return;
        }
        rsp.setStatus(404);
        req.getView((Object)this, "search-failed.jelly").forward((ServletRequest)req, (ServletResponse)rsp);
    }

    public void doSuggestOpenSearch(StaplerRequest2 req, StaplerResponse2 rsp, @QueryParameter String q) throws IOException, jakarta.servlet.ServletException {
        rsp.setContentType(Flavor.JSON.contentType);
        DataWriter w = Flavor.JSON.createDataWriter(null, rsp);
        w.startArray();
        w.value(q);
        w.startArray();
        for (SuggestedItem item : this.getSuggestions(req, q)) {
            w.value(item.getPath());
        }
        w.endArray();
        w.endArray();
    }

    public void doSuggest(StaplerRequest2 req, StaplerResponse2 rsp, @QueryParameter String query) throws IOException, jakarta.servlet.ServletException {
        Result r = new Result();
        for (SuggestedItem curItem : this.getSuggestions(req, query)) {
            String iconName = curItem.item.getSearchIcon();
            if (iconName == null || !iconName.startsWith("symbol-") && !iconName.startsWith("http")) {
                iconName = "symbol-search";
            }
            if (iconName.startsWith("symbol")) {
                r.suggestions.add(new Item(curItem.getPath(), curItem.getUrl(), Symbol.get(new SymbolRequest.Builder().withRaw(iconName).build()), "symbol", curItem.item.getSearchGroup().getDisplayName()));
                continue;
            }
            r.suggestions.add(new Item(curItem.getPath(), curItem.getUrl(), iconName, "image", curItem.item.getSearchGroup().getDisplayName()));
        }
        ExtensionList<SearchGroup> groupsExtensionList = ExtensionList.lookup(SearchGroup.class);
        List<ExtensionComponent<SearchGroup>> components = groupsExtensionList.getComponents();
        Map<String, Double> searchGroupOrdinal = components.stream().collect(Collectors.toMap(k -> ((SearchGroup)k.getInstance()).getDisplayName(), ExtensionComponent::ordinal));
        r.suggestions.sort(Comparator.comparingDouble(item -> searchGroupOrdinal.getOrDefault(item.getGroup(), (Double)Double.MAX_VALUE)).reversed().thenComparing(item -> item.name));
        rsp.serveExposedBean(req, (Object)r, new ExportConfig());
    }

    public SearchResult getSuggestions(StaplerRequest2 req, String query) {
        if (Util.isOverridden(Search.class, this.getClass(), "getSuggestions", StaplerRequest.class, String.class)) {
            return this.getSuggestions(StaplerRequest.fromStaplerRequest2((StaplerRequest2)req), query);
        }
        return this.getSuggestionsImpl(req, query);
    }

    @Deprecated
    public SearchResult getSuggestions(StaplerRequest req, String query) {
        return this.getSuggestionsImpl(StaplerRequest.toStaplerRequest2((StaplerRequest)req), query);
    }

    private SearchResult getSuggestionsImpl(StaplerRequest2 req, String query) {
        HashSet<String> paths = new HashSet<String>();
        SearchResultImpl r = new SearchResultImpl();
        int max = Math.min(req.hasParameter("max") ? Integer.parseInt(req.getParameter("max")) : 100, MAX_SEARCH_SIZE);
        SearchableModelObject smo = this.findClosestSearchableModelObject(req);
        for (SuggestedItem i : Search.suggest(this.makeSuggestIndex(req), query, smo)) {
            if (r.size() >= max) {
                r.hasMoreResults = true;
                break;
            }
            if (!paths.add(i.getPath())) continue;
            r.add(i);
        }
        return r;
    }

    public int getMaxSearchSize() {
        return MAX_SEARCH_SIZE;
    }

    @CheckForNull
    private SearchableModelObject findClosestSearchableModelObject(StaplerRequest2 req) {
        List l = req.getAncestors();
        for (int i = l.size() - 1; i >= 0; --i) {
            Ancestor a = (Ancestor)l.get(i);
            if (!(a.getObject() instanceof SearchableModelObject)) continue;
            return (SearchableModelObject)a.getObject();
        }
        return null;
    }

    private SearchIndex makeSuggestIndex(StaplerRequest2 req) {
        SearchIndexBuilder builder = new SearchIndexBuilder();
        for (Ancestor a : req.getAncestors()) {
            if (!(a.getObject() instanceof SearchableModelObject)) continue;
            SearchableModelObject smo = (SearchableModelObject)a.getObject();
            builder.add(smo.getSearchIndex());
        }
        return builder.make();
    }

    static SuggestedItem findClosestSuggestedItem(List<SuggestedItem> r, String query) {
        for (SuggestedItem curItem : r) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(String.format("item's searchUrl:%s;query=%s", curItem.item.getSearchUrl(), query));
            }
            if (!curItem.item.getSearchUrl().contains(Util.rawEncode(query))) continue;
            return curItem;
        }
        return r.get(0);
    }

    @Deprecated
    public static SuggestedItem find(SearchIndex index, String query) {
        return Search.find(index, query, null);
    }

    public static SuggestedItem find(SearchIndex index, String query, SearchableModelObject searchContext) {
        List<SuggestedItem> r = Search.find(Mode.FIND, index, query, searchContext);
        if (r.isEmpty()) {
            return null;
        }
        if (1 == r.size()) {
            return r.get(0);
        }
        return Search.findClosestSuggestedItem(r, query);
    }

    @Deprecated
    public static List<SuggestedItem> suggest(SearchIndex index, String tokenList) {
        return Search.suggest(index, tokenList, null);
    }

    public static List<SuggestedItem> suggest(SearchIndex index, String tokenList, SearchableModelObject searchContext) {
        class Tag
        implements Comparable<Tag> {
            final SuggestedItem item;
            final int distance;
            final int prefixMatch;
            final /* synthetic */ String val$tokenList;

            Tag(SuggestedItem suggestedItem) {
                this.val$tokenList = suggestedItem;
                this.item = i;
                this.distance = EditDistance.editDistance(i.getPath(), this.val$tokenList);
                this.prefixMatch = i.getPath().startsWith(this.val$tokenList) ? 1 : 0;
            }

            @Override
            public int compareTo(Tag that) {
                int r = this.prefixMatch - that.prefixMatch;
                if (r != 0) {
                    return -r;
                }
                return this.distance - that.distance;
            }
        }
        ArrayList<Tag> buf = new ArrayList<Tag>();
        List<SuggestedItem> items = Search.find(Mode.SUGGEST, index, tokenList, searchContext);
        for (SuggestedItem i : items) {
            buf.add(new Tag(i, tokenList));
        }
        Collections.sort(buf);
        items.clear();
        for (Tag t : buf) {
            items.add(t.item);
        }
        return items;
    }

    private static List<SuggestedItem> find(Mode m, SearchIndex index, String tokenList, SearchableModelObject searchContext) {
        TokenList tokens = new TokenList(tokenList);
        if (tokens.length() == 0) {
            return Collections.emptyList();
        }
        List[] paths = new List[tokens.length() + 1];
        for (int i = 1; i <= tokens.length(); ++i) {
            paths[i] = new ArrayList();
        }
        ArrayList<SearchItem> items = new ArrayList<SearchItem>();
        LOGGER.log(Level.FINE, "tokens={0}", tokens);
        int w = 1;
        for (String token : tokens.subSequence(0)) {
            items.clear();
            m.find(index, token, items);
            for (SearchItem si : items) {
                paths[w].add(SuggestedItem.build(searchContext, si));
                LOGGER.log(Level.FINE, "found search item: {0}", si.getSearchName());
            }
            ++w;
        }
        for (int j = 1; j < tokens.length(); ++j) {
            w = 1;
            for (String token : tokens.subSequence(j)) {
                for (SuggestedItem r : paths[j]) {
                    items.clear();
                    m.find(r.item.getSearchIndex(), token, items);
                    for (SearchItem i : items) {
                        paths[j + w].add(new SuggestedItem(r, i));
                    }
                }
                ++w;
            }
        }
        return paths[tokens.length()];
    }

    @Restricted(value={NoExternalUse.class})
    public Object getTarget() {
        if (!SKIP_PERMISSION_CHECK) {
            Jenkins.get().checkPermission(Jenkins.READ);
        }
        return this;
    }

    @ExportedBean
    public static class Result {
        @Exported
        public List<Item> suggestions = new ArrayList<Item>();
    }

    @ExportedBean(defaultVisibility=999)
    public static class Item {
        @Exported
        public String name;
        private final String url;
        private final String type;
        private final String icon;
        private final String group;

        public Item(String name) {
            this(name, null, null, "symbol", null);
        }

        public Item(String name, String url, String icon, String type, String group) {
            this.name = name;
            this.url = url;
            this.icon = icon;
            this.name = name;
            this.type = type;
            this.group = group;
        }

        @Exported
        public String getUrl() {
            return this.url;
        }

        @Exported
        public String getIcon() {
            return this.icon;
        }

        @Exported
        public String getType() {
            return this.type;
        }

        @Exported
        public String getGroup() {
            return this.group;
        }
    }

    @SuppressFBWarnings(value={"EQ_DOESNT_OVERRIDE_EQUALS"}, justification="TODO needs triage")
    private static class SearchResultImpl
    extends ArrayList<SuggestedItem>
    implements SearchResult {
        private boolean hasMoreResults = false;

        private SearchResultImpl() {
        }

        @Override
        public boolean hasMoreResults() {
            return this.hasMoreResults;
        }
    }

    private static enum Mode {
        FIND{

            @Override
            void find(SearchIndex index, String token, List<SearchItem> result) {
                index.find(token, result);
            }
        }
        ,
        SUGGEST{

            @Override
            void find(SearchIndex index, String token, List<SearchItem> result) {
                index.suggest(token, result);
            }
        };


        abstract void find(SearchIndex var1, String var2, List<SearchItem> var3);
    }

    static final class TokenList {
        private final String[] tokens;

        TokenList(String tokenList) {
            this.tokens = tokenList != null ? tokenList.split("(?<=\\s)(?=\\S)") : MemoryReductionUtil.EMPTY_STRING_ARRAY;
        }

        public int length() {
            return this.tokens.length;
        }

        public List<String> subSequence(final int start) {
            return new AbstractList<String>(){

                @Override
                public String get(int index) {
                    StringBuilder buf = new StringBuilder();
                    for (int i = start; i <= start + index; ++i) {
                        buf.append(tokens[i]);
                    }
                    return buf.toString().trim();
                }

                @Override
                public int size() {
                    return tokens.length - start;
                }
            };
        }

        public String toString() {
            StringBuilder s = new StringBuilder("TokenList{");
            for (String token : this.tokens) {
                s.append(token);
                s.append(",");
            }
            s.append('}');
            return s.toString();
        }
    }
}

