/*
 * Decompiled with CFR 0.152.
 */
package hudson.scheduler;

import hudson.scheduler.Hash;
import hudson.scheduler.Messages;
import jenkins.util.SystemProperties;
import org.antlr.v4.runtime.InputMismatchException;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.TokenStream;

abstract class BaseParser
extends Parser {
    static final int[] LOWER_BOUNDS = new int[]{0, 0, 1, 1, 0};
    static final int[] UPPER_BOUNDS = new int[]{59, 23, 31, 12, 7};
    protected Hash hash = Hash.zero();
    private String errorMessage;
    public static boolean HASH_TOKENS = !"false".equals(SystemProperties.getString(BaseParser.class.getName() + ".hash"));
    public static final int NO_STEP = 1;

    BaseParser(TokenStream input) {
        super(input);
    }

    public void setHash(Hash hash) {
        if (hash == null) {
            hash = Hash.zero();
        }
        this.hash = hash;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    protected long doRange(int start, int end, int step, int field) {
        this.rangeCheck(start, field);
        this.rangeCheck(end, field);
        if (step <= 0) {
            this.error(Messages.BaseParser_MustBePositive(step));
        }
        if (start > end) {
            this.error(Messages.BaseParser_StartEndReversed(end, start));
        }
        long bits = 0L;
        for (int i = start; i <= end; i += step) {
            bits |= 1L << i;
        }
        return bits;
    }

    protected long doRange(int step, int field) {
        return this.doRange(LOWER_BOUNDS[field], UPPER_BOUNDS[field], step, field);
    }

    protected long doHash(int step, int field) {
        int u = UPPER_BOUNDS[field];
        if (field == 2) {
            u = 28;
        }
        if (field == 4) {
            u = 6;
        }
        return this.doHash(LOWER_BOUNDS[field], u, step, field);
    }

    protected long doHash(int s, int e, int step, int field) {
        this.rangeCheck(s, field);
        this.rangeCheck(e, field);
        if (step > e - s + 1) {
            this.error(Messages.BaseParser_OutOfRange(step, 1, e - s + 1));
            throw new AssertionError();
        }
        if (step > 1) {
            long bits = 0L;
            for (int i = this.hash.next(step) + s; i <= e; i += step) {
                bits |= 1L << i;
            }
            assert (bits != 0L);
            return bits;
        }
        if (step <= 0) {
            this.error(Messages.BaseParser_MustBePositive(step));
            throw new AssertionError();
        }
        assert (step == 1);
        return 1L << s + this.hash.next(e + 1 - s);
    }

    protected void rangeCheck(int value, int field) {
        if (value < LOWER_BOUNDS[field] || UPPER_BOUNDS[field] < value) {
            this.error(Messages.BaseParser_OutOfRange(value, LOWER_BOUNDS[field], UPPER_BOUNDS[field]));
        }
    }

    private void error(String msg) {
        this.setErrorMessage(msg);
        throw new InputMismatchException((Parser)this);
    }

    protected Hash getHashForTokens() {
        return HASH_TOKENS ? this.hash : Hash.zero();
    }
}

