/*
 * Decompiled with CFR 0.152.
 */
package hudson.model.queue;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.console.ModelHyperlinkNote;
import hudson.model.Computer;
import hudson.model.Label;
import hudson.model.Messages;
import hudson.model.Node;
import hudson.model.TaskListener;
import java.util.Objects;
import org.jvnet.localizer.Localizable;

public abstract class CauseOfBlockage {
    public abstract String getShortDescription();

    public boolean isFatal() {
        return false;
    }

    public void print(TaskListener listener) {
        listener.getLogger().println(this.getShortDescription());
    }

    public static CauseOfBlockage fromMessage(final @NonNull Localizable l) {
        Objects.requireNonNull(l);
        return new CauseOfBlockage(){

            @Override
            public String getShortDescription() {
                return l.toString();
            }
        };
    }

    public String toString() {
        return this.getShortDescription();
    }

    public static CauseOfBlockage createNeedsMoreExecutor(Localizable l) {
        return new NeedsMoreExecutorImpl(l);
    }

    private static final class NeedsMoreExecutorImpl
    extends CauseOfBlockage
    implements NeedsMoreExecutor {
        private final Localizable l;

        private NeedsMoreExecutorImpl(Localizable l) {
            this.l = l;
        }

        @Override
        public String getShortDescription() {
            return this.l.toString();
        }
    }

    public static final class BecauseLabelIsBusy
    extends CauseOfBlockage
    implements NeedsMoreExecutor {
        public final Label label;

        public BecauseLabelIsBusy(Label label) {
            this.label = label;
        }

        @Override
        public String getShortDescription() {
            return Messages.Queue_WaitingForNextAvailableExecutorOn(this.label.getName());
        }

        @Override
        public void print(TaskListener listener) {
            listener.getLogger().println(Messages.Queue_WaitingForNextAvailableExecutorOn(ModelHyperlinkNote.encodeTo(this.label)));
        }
    }

    public static final class BecauseNodeIsBusy
    extends CauseOfBlockage
    implements NeedsMoreExecutor {
        public final Node node;

        public BecauseNodeIsBusy(Node node) {
            this.node = node;
        }

        @Override
        public String getShortDescription() {
            String name = this.node.toComputer() != null ? this.node.toComputer().getDisplayName() : this.node.getDisplayName();
            return Messages.Queue_WaitingForNextAvailableExecutorOn(name);
        }

        @Override
        public void print(TaskListener listener) {
            listener.getLogger().println(Messages.Queue_WaitingForNextAvailableExecutorOn(ModelHyperlinkNote.encodeTo(this.node)));
        }
    }

    public static final class BecauseLabelIsOffline
    extends CauseOfBlockage
    implements NeedsMoreExecutor {
        public final Label label;

        public BecauseLabelIsOffline(Label l) {
            this.label = l;
        }

        @Override
        public String getShortDescription() {
            if (this.label.isEmpty()) {
                return Messages.Queue_LabelHasNoNodes(this.label.getName());
            }
            return Messages.Queue_AllNodesOffline(this.label.getName());
        }

        @Override
        public void print(TaskListener listener) {
            if (this.label.isEmpty()) {
                listener.getLogger().println(Messages.Queue_LabelHasNoNodes(ModelHyperlinkNote.encodeTo(this.label)));
            } else {
                listener.getLogger().println(Messages.Queue_AllNodesOffline(ModelHyperlinkNote.encodeTo(this.label)));
            }
        }
    }

    public static final class BecauseNodeIsNotAcceptingTasks
    extends CauseOfBlockage
    implements NeedsMoreExecutor {
        public final Node node;

        public BecauseNodeIsNotAcceptingTasks(Node node) {
            this.node = node;
        }

        @Override
        public String getShortDescription() {
            Computer computer = this.node.toComputer();
            String name = computer != null ? computer.getDisplayName() : this.node.getDisplayName();
            return Messages.Node_BecauseNodeIsNotAcceptingTasks(name);
        }

        @Override
        public void print(TaskListener listener) {
            listener.getLogger().println(Messages.Node_BecauseNodeIsNotAcceptingTasks(ModelHyperlinkNote.encodeTo(this.node)));
        }
    }

    public static final class BecauseNodeIsOffline
    extends CauseOfBlockage
    implements NeedsMoreExecutor {
        public final Node node;

        public BecauseNodeIsOffline(Node node) {
            this.node = node;
        }

        @Override
        public String getShortDescription() {
            String name = this.node.toComputer() != null ? this.node.toComputer().getDisplayName() : this.node.getDisplayName();
            return Messages.Queue_NodeOffline(name);
        }

        @Override
        public void print(TaskListener listener) {
            listener.getLogger().println(Messages.Queue_NodeOffline(ModelHyperlinkNote.encodeTo(this.node)));
        }
    }

    static interface NeedsMoreExecutor {
    }
}

