/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.OverrideMustInvoke;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Util;
import hudson.cli.declarative.CLIResolver;
import hudson.console.AnnotatedLargeText;
import hudson.init.Initializer;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Actionable;
import hudson.model.Api;
import hudson.model.BuildTimelineWidget;
import hudson.model.ComputerPanelBox;
import hudson.model.ComputerPinger;
import hudson.model.ComputerSet;
import hudson.model.Descriptor;
import hudson.model.DescriptorByNameOwner;
import hudson.model.Executor;
import hudson.model.ExecutorListener;
import hudson.model.LoadStatistics;
import hudson.model.Messages;
import hudson.model.Node;
import hudson.model.OneOffExecutor;
import hudson.model.Queue;
import hudson.model.RSS;
import hudson.model.Run;
import hudson.model.Slave;
import hudson.model.TaskListener;
import hudson.model.TransientComputerActionFactory;
import hudson.model.User;
import hudson.model.labels.LabelAtom;
import hudson.model.queue.WorkUnit;
import hudson.node_monitors.AbstractDiskSpaceMonitor;
import hudson.node_monitors.DiskSpaceMonitorNodeProperty;
import hudson.node_monitors.NodeMonitor;
import hudson.remoting.Channel;
import hudson.remoting.VirtualChannel;
import hudson.security.ACL;
import hudson.security.AccessControlled;
import hudson.security.Permission;
import hudson.security.PermissionGroup;
import hudson.security.PermissionScope;
import hudson.slaves.ComputerListener;
import hudson.slaves.NodeProperty;
import hudson.slaves.OfflineCause;
import hudson.slaves.RetentionStrategy;
import hudson.slaves.WorkspaceList;
import hudson.triggers.SafeTimerTask;
import hudson.util.ClassLoaderSanityThreadFactory;
import hudson.util.DaemonThreadFactory;
import hudson.util.EditDistance;
import hudson.util.ExceptionCatchingThreadFactory;
import hudson.util.FormApply;
import hudson.util.Futures;
import hudson.util.NamingThreadFactory;
import hudson.util.RemotingDiagnostics;
import hudson.util.RunList;
import jakarta.servlet.ServletException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jenkins.model.DisplayExecutor;
import jenkins.model.IComputer;
import jenkins.model.IDisplayExecutor;
import jenkins.model.Jenkins;
import jenkins.search.SearchGroup;
import jenkins.security.ExtendedReadRedaction;
import jenkins.security.ImpersonatingExecutorService;
import jenkins.security.MasterToSlaveCallable;
import jenkins.security.stapler.StaplerDispatchable;
import jenkins.util.ContextResettingExecutorService;
import jenkins.util.ErrorLoggingExecutorService;
import jenkins.util.Listeners;
import jenkins.util.SystemProperties;
import jenkins.widgets.HasWidgets;
import net.jcip.annotations.GuardedBy;
import org.apache.commons.io.IOUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.stapler.HttpRedirect;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerProxy;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.WebMethod;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;
import org.kohsuke.stapler.interceptor.RequirePOST;
import org.kohsuke.stapler.verb.POST;

@ExportedBean
public abstract class Computer
extends Actionable
implements AccessControlled,
IComputer,
ExecutorListener,
DescriptorByNameOwner,
StaplerProxy,
HasWidgets {
    private final CopyOnWriteArrayList<Executor> executors = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<OneOffExecutor> oneOffExecutors = new CopyOnWriteArrayList();
    private int numExecutors;
    protected volatile OfflineCause offlineCause;
    private long connectTime = 0L;
    protected String nodeName;
    private volatile String cachedHostName;
    private volatile boolean hostNameCached;
    private volatile EnvVars cachedEnvironment;
    private final WorkspaceList workspaceList = new WorkspaceList();
    protected transient List<Action> transientActions;
    protected final Object statusChangeLock = new Object();
    private final Object logDirLock = new Object();
    private final transient List<TerminationRequest> terminatedBy = Collections.synchronizedList(new ArrayList());
    public static final ExecutorService threadPoolForRemoting = new ContextResettingExecutorService(new ImpersonatingExecutorService((ExecutorService)new ErrorLoggingExecutorService(Executors.newCachedThreadPool(new ExceptionCatchingThreadFactory(new NamingThreadFactory(new ClassLoaderSanityThreadFactory(new DaemonThreadFactory()), "Computer.threadPoolForRemoting")))), ACL.SYSTEM2));
    @Restricted(value={NoExternalUse.class})
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="for script console")
    public static boolean SKIP_PERMISSION_CHECK = SystemProperties.getBoolean(Computer.class.getName() + ".skipPermissionCheck");
    public static final PermissionGroup PERMISSIONS = new PermissionGroup(Computer.class, Messages._Computer_Permissions_Title());
    public static final Permission CONFIGURE = new Permission(PERMISSIONS, "Configure", Messages._Computer_ConfigurePermission_Description(), Permission.CONFIGURE, PermissionScope.COMPUTER);
    public static final Permission EXTENDED_READ = new Permission(PERMISSIONS, "ExtendedRead", Messages._Computer_ExtendedReadPermission_Description(), CONFIGURE, SystemProperties.getBoolean("hudson.security.ExtendedReadPermission"), new PermissionScope[]{PermissionScope.COMPUTER});
    public static final Permission DELETE = new Permission(PERMISSIONS, "Delete", Messages._Computer_DeletePermission_Description(), Permission.DELETE, PermissionScope.COMPUTER);
    public static final Permission CREATE = new Permission(PERMISSIONS, "Create", Messages._Computer_CreatePermission_Description(), Permission.CREATE, PermissionScope.JENKINS);
    public static final Permission DISCONNECT = new Permission(PERMISSIONS, "Disconnect", Messages._Computer_DisconnectPermission_Description(), Jenkins.ADMINISTER, PermissionScope.COMPUTER);
    public static final Permission CONNECT = new Permission(PERMISSIONS, "Connect", Messages._Computer_ConnectPermission_Description(), DISCONNECT, PermissionScope.COMPUTER);
    public static final Permission BUILD = new Permission(PERMISSIONS, "Build", Messages._Computer_BuildPermission_Description(), Permission.WRITE, PermissionScope.COMPUTER);
    @Restricted(value={NoExternalUse.class})
    public static final Permission[] EXTENDED_READ_AND_CONNECT = new Permission[]{EXTENDED_READ, CONNECT};
    private static final Logger LOGGER = Logger.getLogger(Computer.class.getName());

    public void recordTermination() {
        StaplerRequest2 request = Stapler.getCurrentRequest2();
        if (request != null) {
            this.terminatedBy.add(new TerminationRequest(String.format("Termination requested at %s by %s [id=%d] from HTTP request for %s", new Date(), Thread.currentThread(), Thread.currentThread().getId(), request.getRequestURL())));
        } else {
            this.terminatedBy.add(new TerminationRequest(String.format("Termination requested at %s by %s [id=%d]", new Date(), Thread.currentThread(), Thread.currentThread().getId())));
        }
    }

    public List<TerminationRequest> getTerminatedBy() {
        return new ArrayList<TerminationRequest>(this.terminatedBy);
    }

    protected Computer(Node node) {
        this.setNode(node);
    }

    public List<ComputerPanelBox> getComputerPanelBoxs() {
        return ComputerPanelBox.all(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public List<Action> getActions() {
        ArrayList<Action> result = new ArrayList<Action>(super.getActions());
        Computer computer = this;
        synchronized (computer) {
            if (this.transientActions == null) {
                this.transientActions = TransientComputerActionFactory.createAllFor(this);
            }
            result.addAll(this.transientActions);
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public void addAction(@NonNull Action a) {
        if (a == null) {
            throw new IllegalArgumentException("Action must be non-null");
        }
        super.getActions().add(a);
    }

    @NonNull
    public File getLogFile() {
        return new File(this.getLogDir(), "slave.log");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    protected File getLogDir() {
        File dir = new File(SafeTimerTask.getLogsRoot(), "slaves/" + this.nodeName);
        Object object = this.logDirLock;
        synchronized (object) {
            try {
                hudson.util.IOUtils.mkdirs(dir);
            }
            catch (IOException x) {
                LOGGER.log(Level.SEVERE, "Failed to create agent log directory " + String.valueOf(dir), x);
            }
        }
        return dir;
    }

    public WorkspaceList getWorkspaceList() {
        return this.workspaceList;
    }

    public String getLog() throws IOException {
        return Util.loadFile(this.getLogFile(), Charset.defaultCharset());
    }

    public AnnotatedLargeText<Computer> getLogText() {
        this.checkAnyPermission(CONNECT, EXTENDED_READ);
        return new AnnotatedLargeText<Computer>(this.getLogFile(), Charset.defaultCharset(), false, this);
    }

    @Override
    @Exported
    public OfflineCause getOfflineCause() {
        OfflineCause temporaryOfflineCause;
        Node node = this.getNode();
        if (node != null && (temporaryOfflineCause = node.getTemporaryOfflineCause()) != null) {
            return temporaryOfflineCause;
        }
        return this.offlineCause;
    }

    @Override
    public boolean hasOfflineCause() {
        return this.offlineCause != null;
    }

    @Override
    @Exported
    public String getOfflineCauseReason() {
        return IComputer.super.getOfflineCauseReason();
    }

    @Nullable
    public abstract VirtualChannel getChannel();

    public abstract Charset getDefaultCharset();

    public abstract List<LogRecord> getLogRecords() throws IOException, InterruptedException;

    public abstract void doLaunchSlaveAgent(StaplerRequest2 var1, StaplerResponse2 var2) throws IOException, ServletException;

    @Deprecated
    public final void launch() {
        this.connect(true);
    }

    @Override
    public final Future<?> connect(boolean forceReconnect) {
        this.connectTime = System.currentTimeMillis();
        return this._connect(forceReconnect);
    }

    protected abstract Future<?> _connect(boolean var1);

    @Deprecated
    public void cliConnect(boolean force) throws ExecutionException, InterruptedException {
        this.checkPermission(CONNECT);
        this.connect(force).get();
    }

    public final long getConnectTime() {
        return this.connectTime;
    }

    public Future<?> disconnect(OfflineCause cause) {
        this.recordTermination();
        this.offlineCause = cause;
        if (Util.isOverridden(Computer.class, this.getClass(), "disconnect", new Class[0])) {
            return this.disconnect();
        }
        this.connectTime = 0L;
        return Futures.precomputed(null);
    }

    @Deprecated
    public Future<?> disconnect() {
        this.recordTermination();
        if (Util.isOverridden(Computer.class, this.getClass(), "disconnect", OfflineCause.class)) {
            return this.disconnect(null);
        }
        this.connectTime = 0L;
        return Futures.precomputed(null);
    }

    @Deprecated
    public void cliDisconnect(String cause) throws ExecutionException, InterruptedException {
        this.checkPermission(DISCONNECT);
        this.disconnect(new OfflineCause.ByCLI(cause)).get();
    }

    @Deprecated
    public void cliOffline(String cause) throws ExecutionException, InterruptedException {
        this.checkPermission(DISCONNECT);
        this.setTemporaryOfflineCause(new OfflineCause.ByCLI(cause));
    }

    @Deprecated
    public void cliOnline() throws ExecutionException, InterruptedException {
        this.checkPermission(CONNECT);
        this.setTemporaryOfflineCause(null);
    }

    @Exported
    public int getNumExecutors() {
        return this.numExecutors;
    }

    @Override
    @NonNull
    public String getName() {
        return this.nodeName != null ? this.nodeName : "";
    }

    @CheckForNull
    public abstract Boolean isUnix();

    @CheckForNull
    public Node getNode() {
        Jenkins j = Jenkins.getInstanceOrNull();
        if (j == null) {
            return null;
        }
        if (this.nodeName == null) {
            return j;
        }
        return j.getNode(this.nodeName);
    }

    @Exported
    public LoadStatistics getLoadStatistics() {
        return LabelAtom.get((String)(this.nodeName != null ? this.nodeName : Jenkins.get().getSelfLabel().toString())).loadStatistics;
    }

    @Deprecated
    @Restricted(value={DoNotUse.class})
    public BuildTimelineWidget getTimeline() {
        return new BuildTimelineWidget(this.getBuilds());
    }

    @Override
    @Exported
    public boolean isOffline() {
        return this.isTemporarilyOffline() || this.getChannel() == null;
    }

    @Override
    public final boolean isOnline() {
        return !this.isOffline();
    }

    @Override
    public boolean isConnected() {
        return this.getChannel() != null;
    }

    @Exported
    public boolean isManualLaunchAllowed() {
        return this.getRetentionStrategy().isManualLaunchAllowed(this);
    }

    @Exported
    @Deprecated
    public boolean isJnlpAgent() {
        return false;
    }

    @Override
    @Exported
    public boolean isLaunchSupported() {
        return true;
    }

    @Exported
    @Deprecated
    public boolean isTemporarilyOffline() {
        Node node = this.getNode();
        return node != null && node.isTemporarilyOffline();
    }

    public void setOfflineCause(OfflineCause cause) {
        this.offlineCause = cause;
    }

    @Deprecated
    public void setTemporarilyOffline(boolean temporarilyOffline) {
        this.setTemporaryOfflineCause(temporarilyOffline ? new OfflineCause.LegacyOfflineCause() : null);
    }

    @Deprecated(since="2.482")
    public void setTemporarilyOffline(boolean temporarilyOffline, OfflineCause cause) {
        if (cause == null) {
            this.setTemporarilyOffline(temporarilyOffline);
        } else {
            this.setTemporaryOfflineCause(temporarilyOffline ? cause : null);
        }
    }

    public void setTemporaryOfflineCause(@CheckForNull OfflineCause temporaryOfflineCause) {
        Node node = this.getNode();
        if (node == null) {
            throw new IllegalStateException("Can't set a temporary offline cause if the node has been removed");
        }
        node.setTemporaryOfflineCause(temporaryOfflineCause);
    }

    public String getTemporaryOfflineCauseReason() {
        Node node = this.getNode();
        if (node == null) {
            return null;
        }
        OfflineCause cause = node.getTemporaryOfflineCause();
        if (cause instanceof OfflineCause.UserCause) {
            OfflineCause.UserCause userCause = (OfflineCause.UserCause)cause;
            return userCause.getMessage();
        }
        return cause != null ? cause.toString() : "";
    }

    @Override
    @Exported
    public String getIcon() {
        return IComputer.super.getIcon();
    }

    @Override
    @Exported
    public String getIconClassName() {
        return IComputer.super.getIconClassName();
    }

    @Override
    @Exported
    @NonNull
    public String getDisplayName() {
        return this.nodeName;
    }

    public String getCaption() {
        return Messages.Computer_Caption(this.nodeName);
    }

    @Override
    @NonNull
    public String getUrl() {
        return "computer/" + Util.fullEncode(this.getName()) + "/";
    }

    @Exported
    public Set<LabelAtom> getAssignedLabels() {
        Node node = this.getNode();
        return node != null ? node.getAssignedLabels() : Collections.emptySet();
    }

    public List<AbstractProject> getTiedJobs() {
        Node node = this.getNode();
        return node != null ? node.getSelfLabel().getTiedJobs() : Collections.emptyList();
    }

    public RunList getBuilds() {
        return RunList.fromJobs(Jenkins.get().allItems(AbstractProject.class)).node(this.getNode());
    }

    protected void setNode(Node node) {
        assert (node != null);
        this.nodeName = node instanceof Slave ? node.getNodeName() : null;
        this.setNumExecutors(node.getNumExecutors());
    }

    protected void kill() {
        this.setNumExecutors(0);
    }

    protected void onRemoved() {
    }

    @Restricted(value={NoExternalUse.class})
    @GuardedBy(value="hudson.model.Queue.lock")
    public void setNumExecutors(int n) {
        this.numExecutors = n;
        int diff = this.executors.size() - n;
        if (diff > 0) {
            Queue.withLock(() -> {
                for (Executor e : this.executors) {
                    if (!e.isIdle()) continue;
                    e.interrupt();
                }
            });
        }
        if (diff < 0) {
            this.addNewExecutorIfNecessary();
        }
    }

    private void addNewExecutorIfNecessary() {
        if (Jenkins.getInstanceOrNull() == null) {
            return;
        }
        HashSet<Integer> availableNumbers = new HashSet<Integer>();
        for (int i = 0; i < this.numExecutors; ++i) {
            availableNumbers.add(i);
        }
        for (Executor executor : this.executors) {
            availableNumbers.remove(executor.getNumber());
        }
        for (Integer number : availableNumbers) {
            if (this.executors.size() >= this.numExecutors) continue;
            Executor e = new Executor(this, number);
            this.executors.add(e);
        }
    }

    @Override
    public int countIdle() {
        int n = 0;
        for (Executor e : this.executors) {
            if (!e.isIdle()) continue;
            ++n;
        }
        return n;
    }

    @Override
    public final int countBusy() {
        return this.countExecutors() - this.countIdle();
    }

    @Override
    public final int countExecutors() {
        return this.executors.size();
    }

    @Exported
    @StaplerDispatchable
    public List<Executor> getExecutors() {
        return new ArrayList<Executor>(this.executors);
    }

    @Exported
    @StaplerDispatchable
    public List<OneOffExecutor> getOneOffExecutors() {
        return new ArrayList<OneOffExecutor>(this.oneOffExecutors);
    }

    public List<Executor> getAllExecutors() {
        ArrayList<Executor> result = new ArrayList<Executor>(this.executors.size() + this.oneOffExecutors.size());
        result.addAll(this.executors);
        result.addAll(this.oneOffExecutors);
        return result;
    }

    @NonNull
    public List<IDisplayExecutor> getDisplayExecutors() {
        ArrayList<IDisplayExecutor> result = new ArrayList<IDisplayExecutor>(this.executors.size() + this.oneOffExecutors.size());
        int index = 0;
        for (Executor executor : this.executors) {
            if (executor.isDisplayCell()) {
                result.add(new DisplayExecutor(Integer.toString(index + 1), String.format("executors/%d", index), executor));
            }
            ++index;
        }
        index = 0;
        for (OneOffExecutor oneOffExecutor : this.oneOffExecutors) {
            if (oneOffExecutor.isDisplayCell()) {
                result.add(new DisplayExecutor("", String.format("oneOffExecutors/%d", index), oneOffExecutor));
            }
            ++index;
        }
        return result;
    }

    @Exported
    public final boolean isIdle() {
        if (!this.oneOffExecutors.isEmpty()) {
            return false;
        }
        for (Executor e : this.executors) {
            if (e.isIdle()) continue;
            return false;
        }
        return true;
    }

    public final boolean isPartiallyIdle() {
        for (Executor e : this.executors) {
            if (!e.isIdle()) continue;
            return true;
        }
        return false;
    }

    public final long getIdleStartMilliseconds() {
        long firstIdle = Long.MIN_VALUE;
        for (Executor executor : this.oneOffExecutors) {
            firstIdle = Math.max(firstIdle, executor.getIdleStartMilliseconds());
        }
        for (Executor executor : this.executors) {
            firstIdle = Math.max(firstIdle, executor.getIdleStartMilliseconds());
        }
        return firstIdle;
    }

    public final long getDemandStartMilliseconds() {
        long firstDemand = Long.MAX_VALUE;
        for (Queue.BuildableItem item : Jenkins.get().getQueue().getBuildableItems(this)) {
            firstDemand = Math.min(item.buildableStartMilliseconds, firstDemand);
        }
        return firstDemand;
    }

    @Restricted(value={DoNotUse.class})
    @Exported
    @NonNull
    public String getDescription() {
        Node node = this.getNode();
        return node != null ? node.getNodeDescription() : "";
    }

    protected void removeExecutor(Executor e) {
        Runnable task = () -> {
            Computer computer = this;
            synchronized (computer) {
                this.executors.remove(e);
                this.oneOffExecutors.remove(e);
                this.addNewExecutorIfNecessary();
                if (!this.isAlive()) {
                    Jenkins ciBase = Jenkins.getInstanceOrNull();
                    if (ciBase != null) {
                        ciBase.removeComputer(this);
                    }
                } else if (this.isIdle()) {
                    threadPoolForRemoting.submit(() -> Listeners.notify(ComputerListener.class, false, l -> l.onIdle(this)));
                }
            }
        };
        if (!Queue.tryWithLock(task)) {
            threadPoolForRemoting.submit(Queue.wrapWithLock(task));
        }
    }

    protected boolean isAlive() {
        for (Executor e : this.executors) {
            if (!e.isActive()) continue;
            return true;
        }
        return false;
    }

    public void interrupt() {
        Queue.withLock(() -> {
            for (Executor e : this.executors) {
                e.interruptForShutdown();
            }
        });
    }

    @Override
    public String getSearchUrl() {
        return this.getUrl();
    }

    @Override
    public SearchGroup getSearchGroup() {
        return SearchGroup.get(SearchGroup.ComputerSearchGroup.class);
    }

    public abstract RetentionStrategy getRetentionStrategy();

    @Exported(inline=true)
    public Map<String, Object> getMonitorData() {
        HashMap<String, Object> r = new HashMap<String, Object>();
        if (this.hasPermission(CONNECT)) {
            for (NodeMonitor monitor : NodeMonitor.getAll()) {
                r.put(monitor.getClass().getName(), monitor.data(this));
            }
        }
        return r;
    }

    @Restricted(value={NoExternalUse.class})
    public Map<NodeMonitor, Object> getMonitoringData() {
        LinkedHashMap<NodeMonitor, Object> r = new LinkedHashMap<NodeMonitor, Object>();
        for (NodeMonitor monitor : NodeMonitor.getAll()) {
            if (monitor.getColumnCaption() == null) continue;
            r.put(monitor, monitor.data(this));
        }
        return r;
    }

    public Map<Object, Object> getSystemProperties() throws IOException, InterruptedException {
        return RemotingDiagnostics.getSystemProperties(this.getChannel());
    }

    @Deprecated
    public Map<String, String> getEnvVars() throws IOException, InterruptedException {
        return this.getEnvironment();
    }

    public EnvVars getEnvironment() throws IOException, InterruptedException {
        EnvVars cachedEnvironment = this.cachedEnvironment;
        if (cachedEnvironment != null) {
            return new EnvVars(cachedEnvironment);
        }
        this.cachedEnvironment = cachedEnvironment = EnvVars.getRemote(this.getChannel());
        return new EnvVars(cachedEnvironment);
    }

    @NonNull
    public EnvVars buildEnvironment(@NonNull TaskListener listener) throws IOException, InterruptedException {
        EnvVars env = new EnvVars();
        Node node = this.getNode();
        if (node == null) {
            return env;
        }
        for (NodeProperty nodeProperty : Jenkins.get().getGlobalNodeProperties()) {
            nodeProperty.buildEnvVars(env, listener);
        }
        for (NodeProperty nodeProperty : node.getNodeProperties()) {
            nodeProperty.buildEnvVars(env, listener);
        }
        String rootUrl = Jenkins.get().getRootUrl();
        if (rootUrl != null) {
            env.put("HUDSON_URL", rootUrl);
            env.put("JENKINS_URL", rootUrl);
        }
        return env;
    }

    public Map<String, String> getThreadDump() throws IOException, InterruptedException {
        return RemotingDiagnostics.getThreadDump(this.getChannel());
    }

    public RemotingDiagnostics.HeapDump getHeapDump() throws IOException {
        return new RemotingDiagnostics.HeapDump(this, this.getChannel());
    }

    public String getHostName() throws IOException, InterruptedException {
        if (this.hostNameCached) {
            return this.cachedHostName;
        }
        VirtualChannel channel = this.getChannel();
        if (channel == null) {
            return null;
        }
        for (String address : channel.call(new ListPossibleNames())) {
            try {
                InetAddress ia = InetAddress.getByName(address);
                if (!(ia instanceof Inet4Address)) {
                    LOGGER.log(Level.FINE, "{0} is not an IPv4 address", address);
                    continue;
                }
                if (!ComputerPinger.checkIsReachable(ia, 3)) {
                    LOGGER.log(Level.FINE, "{0} didn't respond to ping", address);
                    continue;
                }
                this.cachedHostName = ia.getCanonicalHostName();
                this.hostNameCached = true;
                return this.cachedHostName;
            }
            catch (IOException e) {
                LogRecord lr = new LogRecord(Level.FINE, "Failed to parse {0}");
                lr.setThrown(e);
                lr.setParameters(new Object[]{address});
                LOGGER.log(lr);
            }
        }
        this.cachedHostName = channel.call(new GetFallbackName());
        this.hostNameCached = true;
        return this.cachedHostName;
    }

    final void startFlyWeightTask(WorkUnit p) {
        OneOffExecutor e = new OneOffExecutor(this);
        e.start(p);
        this.oneOffExecutors.add(e);
    }

    final void remove(OneOffExecutor e) {
        this.oneOffExecutors.remove(e);
    }

    @Restricted(value={DoNotUse.class})
    public void doRssAll(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException {
        RSS.rss(req, rsp, "Jenkins:" + this.getDisplayName() + " (all builds)", this.getUrl(), this.getBuilds());
    }

    @Restricted(value={DoNotUse.class})
    public void doRssFailed(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException {
        RSS.rss(req, rsp, "Jenkins:" + this.getDisplayName() + " (failed builds)", this.getUrl(), this.getBuilds().failureOnly());
    }

    @Restricted(value={DoNotUse.class})
    public void doRssLatest(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException {
        ArrayList<Run> lastBuilds = new ArrayList<Run>();
        block0: for (AbstractProject p : Jenkins.get().allItems(AbstractProject.class)) {
            if (p.getLastBuild() == null) continue;
            for (Run b = p.getLastBuild(); b != null; b = ((AbstractBuild)b).getPreviousBuild()) {
                if (((AbstractBuild)b).getBuiltOn() != this.getNode()) continue;
                lastBuilds.add(b);
                continue block0;
            }
        }
        RSS.rss(req, rsp, "Jenkins:" + this.getDisplayName() + " (latest builds)", this.getUrl(), RunList.fromRuns(lastBuilds));
    }

    @RequirePOST
    public HttpResponse doToggleOffline(@QueryParameter String offlineMessage) throws IOException, ServletException {
        Node node = this.getNode();
        if (node == null) {
            return HttpResponses.notFound();
        }
        if (node.isTemporarilyOffline()) {
            this.checkPermission(CONNECT);
            this.setTemporaryOfflineCause(null);
            return HttpResponses.redirectToDot();
        }
        return this.doChangeOfflineCause(offlineMessage);
    }

    @RequirePOST
    public HttpResponse doChangeOfflineCause(@QueryParameter String offlineMessage) throws IOException, ServletException {
        this.checkPermission(DISCONNECT);
        this.setTemporaryOfflineCause(new OfflineCause.UserCause(User.current(), Util.fixEmptyAndTrim(offlineMessage)));
        return HttpResponses.redirectToDot();
    }

    public Api getApi() {
        return new Api(this);
    }

    public void doDumpExportTable(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException, InterruptedException {
        this.checkPermission(Jenkins.ADMINISTER);
        rsp.setContentType("text/plain");
        try (PrintWriter w = new PrintWriter(rsp.getWriter());){
            VirtualChannel vc = this.getChannel();
            if (vc instanceof Channel) {
                w.println("Controller to agent");
                ((Channel)vc).dumpExportTable(w);
                w.flush();
                w.println("\n\n\nAgent to controller");
                w.print(vc.call(new DumpExportTableTask()));
            } else {
                w.println(Messages.Computer_BadChannel());
            }
        }
    }

    public void doScript(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException {
        this._doScript(req, rsp, "_script.jelly");
    }

    public void doScriptText(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException {
        this._doScript(req, rsp, "_scriptText.jelly");
    }

    protected void _doScript(StaplerRequest2 req, StaplerResponse2 rsp, String view) throws IOException, ServletException {
        Jenkins._doScript(req, rsp, req.getView((Object)this, view), this.getChannel(), this.getACL());
    }

    @POST
    public void doConfigSubmit(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException, Descriptor.FormException {
        this.checkPermission(CONFIGURE);
        String proposedName = Util.fixEmptyAndTrim(req.getSubmittedForm().getString("name"));
        Jenkins.checkGoodName(proposedName);
        Node node = this.getNode();
        if (node == null) {
            throw new ServletException("No such node " + this.nodeName);
        }
        if (!proposedName.equals(this.nodeName) && Jenkins.get().getNode(proposedName) != null) {
            throw new Descriptor.FormException(Messages.ComputerSet_SlaveAlreadyExists(proposedName), "name");
        }
        String nExecutors = req.getSubmittedForm().getString("numExecutors");
        if (nExecutors == null || nExecutors.isBlank() || Integer.parseInt(nExecutors) <= 0) {
            throw new Descriptor.FormException(Messages.Slave_InvalidConfig_Executors(this.nodeName), "numExecutors");
        }
        Node result = node.reconfigure(req, req.getSubmittedForm());
        Jenkins.get().getNodesObject().replaceNode(this.getNode(), result);
        if (result.getNodeProperty(DiskSpaceMonitorNodeProperty.class) != null) {
            for (NodeMonitor monitor : NodeMonitor.getAll()) {
                if (!(monitor instanceof AbstractDiskSpaceMonitor)) continue;
                monitor.data(this);
            }
        }
        FormApply.success("../" + result.getNodeName() + "/").generateResponse(req, rsp, null);
    }

    @WebMethod(name={"config.xml"})
    public void doConfigDotXml(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException {
        if (req.getMethod().equals("GET")) {
            this.checkPermission(EXTENDED_READ);
            rsp.setContentType("application/xml");
            Node node = this.getNode();
            if (node == null) {
                throw HttpResponses.notFound();
            }
            if (this.hasPermission(CONFIGURE)) {
                Jenkins.XSTREAM2.toXMLUTF8(node, (OutputStream)rsp.getOutputStream());
            } else {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                Jenkins.XSTREAM2.toXMLUTF8(node, baos);
                String xml = baos.toString(StandardCharsets.UTF_8);
                xml = ExtendedReadRedaction.applyAll(xml);
                IOUtils.write((String)xml, (OutputStream)rsp.getOutputStream(), (Charset)StandardCharsets.UTF_8);
            }
            return;
        }
        if (req.getMethod().equals("POST")) {
            this.updateByXml((InputStream)req.getInputStream());
            return;
        }
        rsp.sendError(400);
    }

    public void updateByXml(InputStream source) throws IOException, ServletException {
        this.checkPermission(CONFIGURE);
        Node previous = this.getNode();
        if (previous == null) {
            throw HttpResponses.notFound();
        }
        Node result = (Node)Jenkins.XSTREAM2.fromXML(source);
        if (previous.getClass() != result.getClass()) {
            throw HttpResponses.errorWithoutStack((int)400, (String)"Node types do not match");
        }
        Jenkins.get().getNodesObject().replaceNode(previous, result);
    }

    @RequirePOST
    public HttpResponse doDoDelete() throws IOException {
        this.checkPermission(DELETE);
        Node node = this.getNode();
        if (node != null) {
            Jenkins.get().removeNode(node);
        } else {
            Jenkins app = Jenkins.get();
            app.removeComputer(this);
        }
        return new HttpRedirect("..");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilOnline() throws InterruptedException {
        Object object = this.statusChangeLock;
        synchronized (object) {
            while (!this.isOnline()) {
                this.statusChangeLock.wait(1000L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilOffline() throws InterruptedException {
        Object object = this.statusChangeLock;
        synchronized (object) {
            while (!this.isOffline()) {
                this.statusChangeLock.wait(1000L);
            }
        }
    }

    public void doProgressiveLog(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException {
        this.getLogText().doProgressText(req, rsp);
    }

    @Restricted(value={NoExternalUse.class})
    public Object getTarget() {
        if (!SKIP_PERMISSION_CHECK) {
            Jenkins.get().checkPermission(Jenkins.READ);
        }
        return this;
    }

    @Nullable
    public static Computer currentComputer() {
        Executor e = Executor.currentExecutor();
        return e != null ? e.getOwner() : null;
    }

    @Override
    @OverrideMustInvoke
    public boolean isAcceptingTasks() {
        Node node = this.getNode();
        return this.getRetentionStrategy().isAcceptingTasks(this) && (node == null || node.isAcceptingTasks());
    }

    @CLIResolver
    public static Computer resolveForCLI(@Argument(required=true, metaVar="NAME", usage="Agent name, or empty string for built-in node") String name) throws CmdLineException {
        Jenkins h = Jenkins.get();
        Computer item = h.getComputer(name);
        if (item == null) {
            List<String> names = ComputerSet.getComputerNames();
            String adv = EditDistance.findNearest(name, names);
            throw new IllegalArgumentException(adv == null ? Messages.Computer_NoSuchSlaveExistsWithoutAdvice(name) : Messages.Computer_NoSuchSlaveExists(name, adv));
        }
        return item;
    }

    @Initializer
    public static void relocateOldLogs() {
        Computer.relocateOldLogs(Jenkins.get().getRootDir());
    }

    @SuppressFBWarnings(value={"REDOS"}, justification="TODO needs triage")
    static void relocateOldLogs(File dir) {
        Pattern logfile = Pattern.compile("slave-(.*)\\.log(\\.[0-9]+)?");
        File[] logfiles = dir.listFiles((dir1, name) -> logfile.matcher(name).matches());
        if (logfiles == null) {
            return;
        }
        for (File f : logfiles) {
            Matcher m = logfile.matcher(f.getName());
            if (m.matches()) {
                File newLocation = new File(dir, "logs/slaves/" + m.group(1) + "/slave.log" + Util.fixNull(m.group(2)));
                try {
                    Util.createDirectories(newLocation.getParentFile().toPath(), new FileAttribute[0]);
                    Files.move(f.toPath(), newLocation.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    LOGGER.log(Level.INFO, "Relocated log file {0} to {1}", new Object[]{f.getPath(), newLocation.getPath()});
                }
                catch (IOException | InvalidPathException e) {
                    LOGGER.log(Level.WARNING, e, () -> "Cannot relocate log file " + f.getPath() + " to " + newLocation.getPath());
                }
                continue;
            }
            assert (false);
        }
    }

    public static class TerminationRequest
    extends RuntimeException {
        private final long when = System.currentTimeMillis();

        public TerminationRequest(String message) {
            super(message);
        }

        public long getWhen() {
            return this.when;
        }
    }

    private static class ListPossibleNames
    extends MasterToSlaveCallable<List<String>, IOException> {
        private static final Logger LOGGER = Logger.getLogger(ListPossibleNames.class.getName());
        private static final long serialVersionUID = 1L;

        private ListPossibleNames() {
        }

        @Override
        public List<String> call() throws IOException {
            ArrayList<String> names = new ArrayList<String>();
            Enumeration<NetworkInterface> nis = NetworkInterface.getNetworkInterfaces();
            while (nis.hasMoreElements()) {
                NetworkInterface ni = nis.nextElement();
                LOGGER.log(Level.FINE, "Listing up IP addresses for {0}", ni.getDisplayName());
                Enumeration<InetAddress> e = ni.getInetAddresses();
                while (e.hasMoreElements()) {
                    InetAddress ia = e.nextElement();
                    if (ia.isLoopbackAddress()) {
                        LOGGER.log(Level.FINE, "{0} is a loopback address", ia);
                        continue;
                    }
                    if (!(ia instanceof Inet4Address)) {
                        LOGGER.log(Level.FINE, "{0} is not an IPv4 address", ia);
                        continue;
                    }
                    LOGGER.log(Level.FINE, "{0} is a viable candidate", ia);
                    names.add(ia.getHostAddress());
                }
            }
            return names;
        }
    }

    private static class GetFallbackName
    extends MasterToSlaveCallable<String, IOException> {
        private static final long serialVersionUID = 1L;

        private GetFallbackName() {
        }

        @Override
        public String call() throws IOException {
            return SystemProperties.getString("host.name");
        }
    }

    private static final class DumpExportTableTask
    extends MasterToSlaveCallable<String, IOException> {
        private DumpExportTableTask() {
        }

        @Override
        public String call() throws IOException {
            Channel ch = this.getChannelOrFail();
            StringWriter sw = new StringWriter();
            try (PrintWriter pw = new PrintWriter(sw);){
                ch.dumpExportTable(pw);
            }
            return sw.toString();
        }
    }

    @Extension(ordinal=1.7976931348623157E308)
    @Restricted(value={DoNotUse.class})
    public static class InternalComputerListener
    extends ComputerListener {
        @Override
        public void onOnline(Computer c, TaskListener listener) throws IOException, InterruptedException {
            c.cachedEnvironment = null;
        }
    }
}

