/*
 * Decompiled with CFR 0.152.
 */
package hudson.init;

import hudson.PluginManager;
import hudson.util.DirScanner;
import hudson.util.FileVisitor;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.util.SystemProperties;
import org.jvnet.hudson.reactor.Task;

public class InitStrategy {
    private static final Logger LOGGER = Logger.getLogger(InitStrategy.class.getName());

    public List<File> listPluginArchives(PluginManager pm) throws IOException {
        ArrayList<File> r = new ArrayList<File>();
        this.getBundledPluginsFromProperty(r);
        this.listPluginFiles(pm, ".jpl", r);
        this.listPluginFiles(pm, ".hpl", r);
        this.listPluginFiles(pm, ".jpi", r);
        this.listPluginFiles(pm, ".hpi", r);
        return r;
    }

    private void listPluginFiles(PluginManager pm, String extension, Collection<File> all) throws IOException {
        File[] files = pm.rootDir.listFiles(new FilterByExtension(extension));
        if (files == null) {
            throw new IOException("Jenkins is unable to create " + String.valueOf(pm.rootDir) + "\nPerhaps its security privilege is insufficient");
        }
        ArrayList<File> pluginFiles = new ArrayList<File>();
        pluginFiles.addAll(List.of(files));
        pluginFiles.sort(Comparator.comparing(File::getName));
        all.addAll(pluginFiles);
    }

    protected void getBundledPluginsFromProperty(List<File> r) {
        String hplProperty = SystemProperties.getString("hudson.bundled.plugins");
        if (hplProperty != null) {
            final ArrayList<File> pluginFiles = new ArrayList<File>();
            for (String hplLocation : hplProperty.split(",")) {
                File hpl = new File(hplLocation.trim());
                if (hpl.exists()) {
                    pluginFiles.add(hpl);
                    continue;
                }
                if (hpl.getName().contains("*")) {
                    try {
                        new DirScanner.Glob(hpl.getName(), null).scan(hpl.getParentFile(), new FileVisitor(this){

                            @Override
                            public void visit(File f, String relativePath) throws IOException {
                                pluginFiles.add(f);
                            }
                        });
                    }
                    catch (IOException x) {
                        LOGGER.log(Level.WARNING, "could not expand " + hplLocation, x);
                    }
                    continue;
                }
                LOGGER.warning("bundled plugin " + hplLocation + " does not exist");
            }
            pluginFiles.sort(Comparator.comparing(File::getName));
            r.addAll(pluginFiles);
        }
    }

    public boolean skipInitTask(Task task) {
        return false;
    }

    public static InitStrategy get(ClassLoader cl) throws IOException {
        Iterator<InitStrategy> it = ServiceLoader.load(InitStrategy.class, cl).iterator();
        if (!it.hasNext()) {
            return new InitStrategy();
        }
        InitStrategy s = it.next();
        LOGGER.log(Level.FINE, "Using {0} as InitStrategy", s);
        return s;
    }

    private static class FilterByExtension
    implements FilenameFilter {
        private final List<String> extensions;

        FilterByExtension(String ... extensions) {
            this.extensions = Arrays.asList(extensions);
        }

        @Override
        public boolean accept(File dir, String name) {
            for (String extension : this.extensions) {
                if (!name.endsWith(extension)) continue;
                return true;
            }
            return false;
        }
    }
}

