/*
 * Decompiled with CFR 0.152.
 */
package hudson.console;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.MarkupText;
import hudson.console.ConsoleAnnotatorFactory;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;

public abstract class ConsoleAnnotator<T>
implements Serializable {
    private static final long serialVersionUID = 1L;

    @CheckForNull
    public abstract ConsoleAnnotator<T> annotate(@NonNull T var1, @NonNull MarkupText var2);

    public static <T> ConsoleAnnotator<T> cast(ConsoleAnnotator<? super T> a) {
        return a;
    }

    public static <T> ConsoleAnnotator<T> combine(Collection<? extends ConsoleAnnotator<? super T>> all) {
        switch (all.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return ConsoleAnnotator.cast(all.iterator().next());
            }
        }
        return new ConsoleAnnotatorAggregator(all);
    }

    public static <T> ConsoleAnnotator<T> initial(T context) {
        return ConsoleAnnotator.combine(ConsoleAnnotator._for(context));
    }

    public static <T> List<ConsoleAnnotator<T>> _for(T context) {
        ArrayList<ConsoleAnnotator<T>> r = new ArrayList<ConsoleAnnotator<T>>();
        for (ConsoleAnnotatorFactory f : ConsoleAnnotatorFactory.all()) {
            ConsoleAnnotator<T> ca;
            if (!f.type().isInstance(context) || (ca = f.newInstance(context)) == null) continue;
            r.add(ca);
        }
        return r;
    }

    private static final class ConsoleAnnotatorAggregator<T>
    extends ConsoleAnnotator<T> {
        List<ConsoleAnnotator<T>> list;

        ConsoleAnnotatorAggregator(Collection list) {
            this.list = new ArrayList<ConsoleAnnotator<T>>(list);
        }

        @Override
        public ConsoleAnnotator annotate(T context, MarkupText text) {
            ListIterator<ConsoleAnnotator<T>> itr = this.list.listIterator();
            while (itr.hasNext()) {
                ConsoleAnnotator<T> b;
                ConsoleAnnotator<T> a = itr.next();
                if (a == (b = a.annotate(context, text))) continue;
                if (b == null) {
                    itr.remove();
                    continue;
                }
                itr.set(b);
            }
            switch (this.list.size()) {
                case 0: {
                    return null;
                }
                case 1: {
                    return this.list.get(0);
                }
            }
            return this;
        }

        public String toString() {
            return "ConsoleAnnotatorAggregator" + String.valueOf(this.list);
        }
    }
}

