/*
 * Decompiled with CFR 0.152.
 */
package hudson.cli.declarative;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.ExtensionComponent;
import hudson.ExtensionFinder;
import hudson.Util;
import hudson.cli.CLICommand;
import hudson.cli.CloneableCLICommand;
import hudson.cli.declarative.CLIMethod;
import hudson.cli.declarative.CLIResolver;
import hudson.cli.declarative.MethodBinder;
import hudson.model.Hudson;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.ExtensionComponentSet;
import jenkins.ExtensionRefreshException;
import jenkins.cli.listeners.CLIContext;
import jenkins.cli.listeners.CLIListener;
import jenkins.model.Jenkins;
import jenkins.util.Listeners;
import org.jvnet.hudson.annotation_indexer.Index;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.ParserProperties;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

@Extension
public class CLIRegisterer
extends ExtensionFinder {
    private static final Logger LOGGER = Logger.getLogger(CLIRegisterer.class.getName());

    @Override
    public ExtensionComponentSet refresh() throws ExtensionRefreshException {
        return ExtensionComponentSet.EMPTY;
    }

    @Override
    public <T> Collection<ExtensionComponent<T>> find(Class<T> type, Hudson jenkins) {
        if (type == CLICommand.class) {
            return this.discover(jenkins);
        }
        return Collections.emptyList();
    }

    private Method findResolver(Class type) throws IOException {
        List<Method> resolvers = Util.filter(Index.list(CLIResolver.class, (ClassLoader)Jenkins.get().getPluginManager().uberClassLoader), Method.class);
        while (type != null) {
            for (Method m : resolvers) {
                if (m.getReturnType() != type) continue;
                return m;
            }
            type = type.getSuperclass();
        }
        return null;
    }

    private List<ExtensionComponent<CLICommand>> discover(final @NonNull Jenkins jenkins) {
        LOGGER.fine("Listing up @CLIMethod");
        ArrayList<ExtensionComponent<CLICommand>> r = new ArrayList<ExtensionComponent<CLICommand>>();
        try {
            for (final Method m : Util.filter(Index.list(CLIMethod.class, (ClassLoader)jenkins.getPluginManager().uberClassLoader), Method.class)) {
                try {
                    final String name = m.getAnnotation(CLIMethod.class).name();
                    final ResourceBundleHolder res = this.loadMessageBundle(m);
                    res.format("CLI." + name + ".shortDescription", new Object[0]);
                    r.add(new ExtensionComponent<1>(new CloneableCLICommand(){

                        @Override
                        public String getName() {
                            return name;
                        }

                        @Override
                        public String getShortDescription() {
                            return res.format("CLI." + name + ".shortDescription", new Object[0]);
                        }

                        @Override
                        protected CmdLineParser getCmdLineParser() {
                            return this.bindMethod(new ArrayList<MethodBinder>());
                        }

                        private CmdLineParser bindMethod(List<MethodBinder> binders) {
                            Stack<Method> chains;
                            CmdLineParser parser;
                            block4: {
                                Class<?> type;
                                ParserProperties properties = ParserProperties.defaults().withAtSyntax(ALLOW_AT_SYNTAX);
                                parser = new CmdLineParser(null, properties);
                                chains = new Stack<Method>();
                                Method method = m;
                                do {
                                    chains.push(method);
                                    if (Modifier.isStatic(method.getModifiers())) break block4;
                                    type = method.getDeclaringClass();
                                    try {
                                        method = CLIRegisterer.this.findResolver(type);
                                    }
                                    catch (IOException ex) {
                                        throw new RuntimeException("Unable to find the resolver method annotated with @CLIResolver for " + String.valueOf(type), ex);
                                    }
                                } while (method != null);
                                throw new RuntimeException("Unable to find the resolver method annotated with @CLIResolver for " + String.valueOf(type));
                            }
                            while (!chains.isEmpty()) {
                                binders.add(new MethodBinder((Method)chains.pop(), this, parser));
                            }
                            return parser;
                        }

                        @Override
                        public int main(List<String> args, Locale locale, InputStream stdin, PrintStream stdout, PrintStream stderr) {
                            int n;
                            this.stdout = stdout;
                            this.stderr = stderr;
                            this.locale = locale;
                            ArrayList<MethodBinder> binders = new ArrayList<MethodBinder>();
                            Authentication auth = this.getTransportAuthentication2();
                            CLIContext context = new CLIContext(this.getName(), args, auth);
                            CmdLineParser parser = this.bindMethod(binders);
                            SecurityContext sc = SecurityContextHolder.getContext();
                            Authentication old = sc.getAuthentication();
                            try {
                                parser.parseArgument(args);
                                sc.setAuthentication(auth);
                                jenkins.checkPermission(Jenkins.READ);
                                Listeners.notify(CLIListener.class, true, listener -> listener.onExecution(context));
                                Object instance = null;
                                for (MethodBinder binder : binders) {
                                    instance = binder.call(instance);
                                }
                                Integer exitCode = instance instanceof Integer ? (Integer)instance : 0;
                                Listeners.notify(CLIListener.class, true, listener -> listener.onCompleted(context, exitCode));
                                n = exitCode;
                            }
                            catch (InvocationTargetException e) {
                                try {
                                    try {
                                        Throwable t = e.getTargetException();
                                        if (t instanceof Exception) {
                                            throw (Exception)t;
                                        }
                                        throw e;
                                    }
                                    catch (Throwable throwable) {
                                        sc.setAuthentication(old);
                                        throw throwable;
                                    }
                                }
                                catch (Throwable e2) {
                                    int exitCode = this.handleException(e2, context, parser);
                                    Listeners.notify(CLIListener.class, true, listener -> listener.onThrowable(context, e2));
                                    return exitCode;
                                }
                            }
                            sc.setAuthentication(old);
                            return n;
                        }

                        @Override
                        protected int run() throws Exception {
                            throw new UnsupportedOperationException();
                        }
                    }));
                }
                catch (ClassNotFoundException | MissingResourceException e) {
                    LOGGER.log(Level.SEVERE, "Failed to process @CLIMethod: " + String.valueOf(m), e);
                }
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Failed to discover @CLIMethod", e);
        }
        return r;
    }

    private ResourceBundleHolder loadMessageBundle(Method m) throws ClassNotFoundException {
        Class<?> c = m.getDeclaringClass();
        Class<?> msg = c.getClassLoader().loadClass(c.getName().substring(0, c.getName().lastIndexOf(".")) + ".Messages");
        return ResourceBundleHolder.get(msg);
    }
}

