/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.lib.versionnumber;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.util.VersionNumber;
import java.util.Collections;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;

public class JavaSpecificationVersion
extends VersionNumber {
    private static final String JAVA_SPEC_VERSION_PROPERTY_NAME = "java.specification.version";
    public static final JavaSpecificationVersion JAVA_5 = new JavaSpecificationVersion("1.5");
    public static final JavaSpecificationVersion JAVA_6 = new JavaSpecificationVersion("1.6");
    public static final JavaSpecificationVersion JAVA_7 = new JavaSpecificationVersion("1.7");
    public static final JavaSpecificationVersion JAVA_8 = new JavaSpecificationVersion("1.8");
    public static final JavaSpecificationVersion JAVA_9 = new JavaSpecificationVersion("9");
    public static final JavaSpecificationVersion JAVA_10 = new JavaSpecificationVersion("10");
    public static final JavaSpecificationVersion JAVA_11 = new JavaSpecificationVersion("11");
    public static final JavaSpecificationVersion JAVA_12 = new JavaSpecificationVersion("12");
    public static final JavaSpecificationVersion JAVA_13 = new JavaSpecificationVersion("13");
    private static final NavigableMap<Integer, Integer> RELEASE_TO_CLASS;
    private static final NavigableMap<Integer, Integer> CLASS_TO_RELEASE;

    public JavaSpecificationVersion(@NonNull String version) throws NumberFormatException {
        super(JavaSpecificationVersion.normalizeVersion(version));
    }

    public static JavaSpecificationVersion fromReleaseVersion(int releaseVersion) {
        if (releaseVersion > 8) {
            return new JavaSpecificationVersion(Integer.toString(releaseVersion));
        }
        return new JavaSpecificationVersion("1." + releaseVersion);
    }

    public int toReleaseVersion() {
        int first = this.getDigitAt(0);
        return first == 1 ? this.getDigitAt(1) : first;
    }

    public static JavaSpecificationVersion fromClassVersion(int classVersion) {
        Integer releaseVersion = (Integer)CLASS_TO_RELEASE.get(classVersion);
        if (releaseVersion == null) {
            throw new IllegalArgumentException("Unknown Java specification version for class version: " + classVersion);
        }
        return JavaSpecificationVersion.fromReleaseVersion(releaseVersion);
    }

    public int toClassVersion() {
        int releaseVersion = this.toReleaseVersion();
        Integer classVersion = (Integer)RELEASE_TO_CLASS.get(releaseVersion);
        if (classVersion == null) {
            throw new IllegalArgumentException("Unknown class version for release version: " + releaseVersion);
        }
        return classVersion;
    }

    @NonNull
    private static String normalizeVersion(@NonNull String input) throws NumberFormatException {
        int majorVersion;
        if ((input = input.trim()).startsWith("1.")) {
            String[] split = input.split("\\.");
            if (split.length != 2) {
                throw new NumberFormatException("Malformed old Java Specification Version. There should be exactly one dot and something after it: " + input);
            }
            input = split[1];
        }
        if ((majorVersion = Integer.parseInt(input)) > 8) {
            return input;
        }
        return "1." + input;
    }

    @NonNull
    public static JavaSpecificationVersion forCurrentJVM() throws NumberFormatException {
        String value = System.getProperty(JAVA_SPEC_VERSION_PROPERTY_NAME);
        if (value == null) {
            throw new IllegalStateException("Missing mandatory JVM system property: java.specification.version");
        }
        return new JavaSpecificationVersion(value);
    }

    static {
        TreeMap<Integer, Integer> releaseToClass = new TreeMap<Integer, Integer>();
        releaseToClass.put(1, 45);
        releaseToClass.put(2, 46);
        releaseToClass.put(3, 47);
        releaseToClass.put(4, 48);
        releaseToClass.put(5, 49);
        releaseToClass.put(6, 50);
        releaseToClass.put(7, 51);
        releaseToClass.put(8, 52);
        releaseToClass.put(9, 53);
        releaseToClass.put(10, 54);
        releaseToClass.put(11, 55);
        releaseToClass.put(12, 56);
        releaseToClass.put(13, 57);
        releaseToClass.put(14, 58);
        releaseToClass.put(15, 59);
        releaseToClass.put(16, 60);
        releaseToClass.put(17, 61);
        releaseToClass.put(18, 62);
        releaseToClass.put(19, 63);
        releaseToClass.put(20, 64);
        releaseToClass.put(21, 65);
        releaseToClass.put(22, 66);
        releaseToClass.put(23, 67);
        releaseToClass.put(24, 68);
        releaseToClass.put(25, 69);
        RELEASE_TO_CLASS = Collections.unmodifiableNavigableMap(releaseToClass);
        TreeMap<Integer, Integer> classToRelease = new TreeMap<Integer, Integer>();
        for (Map.Entry entry : releaseToClass.entrySet()) {
            classToRelease.put((Integer)entry.getValue(), (Integer)entry.getKey());
        }
        CLASS_TO_RELEASE = Collections.unmodifiableNavigableMap(classToRelease);
    }
}

