/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import org.kohsuke.stapler.ClassLoaderValue;
import org.kohsuke.stapler.TearOffSupport;

public class MetaClassLoader
extends TearOffSupport {
    public final MetaClassLoader parent;
    public final ClassLoader loader;
    @SuppressFBWarnings(value={"MS_SHOULD_BE_REFACTORED_TO_BE_FINAL"}, justification="Legacy switch.")
    public static MetaClassLoader debugLoader = null;
    private static final ClassLoaderValue<MetaClassLoader> classMap = new ClassLoaderValue<MetaClassLoader>(){

        @Override
        protected MetaClassLoader computeValue(ClassLoader cl) {
            return new MetaClassLoader(cl);
        }
    };

    public MetaClassLoader(ClassLoader loader) {
        this.loader = loader;
        this.parent = MetaClassLoader.get(loader.getParent());
    }

    public static MetaClassLoader get(ClassLoader cl) {
        if (cl == null) {
            return null;
        }
        return classMap.get(cl);
    }

    private static MetaClassLoader createDebugLoader() {
        try {
            String path = System.getProperty("stapler.resourcePath");
            if (path != null) {
                String[] tokens = path.split(";");
                URL[] urls = new URL[tokens.length];
                for (int i = 0; i < tokens.length; ++i) {
                    urls[i] = new File(tokens[i]).toURI().toURL();
                }
                return new MetaClassLoader(new URLClassLoader(urls));
            }
        }
        catch (MalformedURLException e) {
            throw new Error(e);
        }
        return null;
    }

    static {
        debugLoader = MetaClassLoader.createDebugLoader();
    }
}

