/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler;

import jakarta.servlet.http.HttpSession;
import java.util.UUID;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.ReflectionUtils;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerRequest2;

public abstract class CrumbIssuer {
    public static final CrumbIssuer DEFAULT = new CrumbIssuer(){

        @Override
        public String issueCrumb(StaplerRequest2 request) {
            HttpSession s = request.getSession();
            String v = (String)s.getAttribute(ATTRIBUTE_NAME);
            if (v != null) {
                return v;
            }
            v = UUID.randomUUID().toString();
            s.setAttribute(ATTRIBUTE_NAME, (Object)v);
            return v;
        }
    };
    private static final String ATTRIBUTE_NAME = CrumbIssuer.class.getName();

    public String issueCrumb(StaplerRequest2 request) {
        return ReflectionUtils.ifOverridden(() -> this.issueCrumb(StaplerRequest.fromStaplerRequest2(request)), CrumbIssuer.class, this.getClass(), "issueCrumb", StaplerRequest.class);
    }

    @Deprecated
    public String issueCrumb(StaplerRequest request) {
        return ReflectionUtils.ifOverridden(() -> this.issueCrumb(StaplerRequest.toStaplerRequest2(request)), CrumbIssuer.class, this.getClass(), "issueCrumb", StaplerRequest2.class);
    }

    public final String issueCrumb() {
        return this.issueCrumb(Stapler.getCurrentRequest2());
    }

    public HttpResponse doCrumb() {
        return HttpResponses.text(this.issueCrumb());
    }

    public void validateCrumb(StaplerRequest2 request, String submittedCrumb) {
        if (!this.issueCrumb(request).equals(submittedCrumb)) {
            throw new SecurityException("Request failed to pass the crumb test (try clearing your cookies)");
        }
    }

    @Deprecated
    public void validateCrumb(StaplerRequest request, String submittedCrumb) {
        this.validateCrumb(StaplerRequest.toStaplerRequest2(request), submittedCrumb);
    }
}

