/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.commons.beanutils.Converter;
import org.kohsuke.stapler.HttpResponses;

public final class AcceptHeader {
    private final List<Atom> atoms = new ArrayList<Atom>();
    private final String ranges;

    public AcceptHeader(String ranges) {
        this.ranges = ranges;
        for (String r : ranges.split(",")) {
            if (r.isEmpty()) continue;
            this.atoms.add(new Atom(r.trim()));
        }
    }

    private static boolean wildcardMatch(String a, String b) {
        return a.equals(b) || a.equals("*") || b.equals("*");
    }

    @Nullable
    protected Atom match(String mimeType) {
        Atom target = new Atom(mimeType);
        int bestFitness = -1;
        Atom best = null;
        for (Atom a : this.atoms) {
            int f = a.fit(target);
            if (f <= bestFitness) continue;
            best = a;
            bestFitness = f;
        }
        return best;
    }

    public String select(Iterable<String> supported) {
        float bestQ = 0.0f;
        String best = null;
        for (String s : supported) {
            Atom a = this.match(s);
            if (a == null || !(a.q > bestQ)) continue;
            bestQ = a.q;
            best = s;
        }
        if (best == null) {
            throw HttpResponses.error(406, "Requested MIME types '" + this.ranges + "' didn't match any of the available options " + String.valueOf(supported));
        }
        return best;
    }

    public String select(String ... supported) {
        return this.select(Arrays.asList(supported));
    }

    public String toString() {
        return super.toString() + "[" + this.ranges + "]";
    }

    protected static class Atom {
        private final String major;
        private final String minor;
        private final Map<String, String> params = new HashMap<String, String>();
        private final float q;

        public String toString() {
            StringBuilder s = new StringBuilder(this.major + "/" + this.minor);
            for (Map.Entry<String, String> k : this.params.entrySet()) {
                s.append(";").append(k.getKey()).append("=").append(k.getValue());
            }
            return s.toString();
        }

        protected Atom(String range) {
            float q;
            String[] parts = (String[])Stream.of(range.split(";")).filter(tok -> !tok.isEmpty()).toArray(String[]::new);
            for (int i = 1; i < parts.length; ++i) {
                String p = parts[i];
                String[] subParts = p.split("=");
                if (subParts.length != 2 || subParts[0].isEmpty() || subParts[1].isEmpty()) continue;
                this.params.put(subParts[0].trim(), subParts[1].trim());
            }
            String fullType = parts[0].trim();
            if (fullType.equals("*")) {
                fullType = "*/*";
            }
            String[] types = (String[])Stream.of(fullType.split("/")).filter(tok -> !tok.isEmpty()).toArray(String[]::new);
            this.major = types[0].trim();
            this.minor = types[1].trim();
            try {
                String param = this.params.get("q");
                q = param != null ? Float.parseFloat(param) : 1.0f;
            }
            catch (NumberFormatException e) {
                q = 1.0f;
            }
            if (q < 0.0f || q > 1.0f) {
                q = 1.0f;
            }
            this.q = q;
            this.params.remove("q");
        }

        private int fit(Atom that) {
            if (!AcceptHeader.wildcardMatch(that.major, this.major) || !AcceptHeader.wildcardMatch(that.minor, this.minor)) {
                return -1;
            }
            int fitness = this.major.equals(that.major) ? 10000 : 0;
            fitness += this.minor.equals(that.minor) ? 1000 : 0;
            for (String k : that.params.keySet()) {
                if (!that.params.get(k).equals(this.params.get(k))) continue;
                ++fitness;
            }
            return fitness;
        }
    }

    public static class StaplerConverterImpl
    implements Converter {
        public Object convert(Class type, Object value) {
            return new AcceptHeader(value.toString());
        }
    }
}

