/*
 * Decompiled with CFR 0.152.
 */
package jenkins.widgets;

import com.google.common.collect.Iterables;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.model.AbstractBuild;
import hudson.model.Job;
import hudson.model.ParameterValue;
import hudson.search.UserSearchProperty;
import hudson.util.Iterators;
import hudson.widgets.HistoryWidget;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import jenkins.model.HistoricalBuild;
import jenkins.model.queue.QueueItem;
import jenkins.widgets.HistoryPageEntry;

public class HistoryPageFilter<T> {
    private final int maxEntries;
    private Long newerThan;
    private Long olderThan;
    private String searchString;
    public final List<HistoryPageEntry<QueueItem>> queueItems = new ArrayList<HistoryPageEntry<QueueItem>>();
    public final List<HistoryPageEntry<HistoricalBuild>> runs = new ArrayList<HistoryPageEntry<HistoricalBuild>>();
    @SuppressFBWarnings(value={"PA_PUBLIC_PRIMITIVE_ATTRIBUTE", "URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"}, justification="Preserve API compatibility; read by Stapler")
    public boolean hasUpPage = false;
    @SuppressFBWarnings(value={"PA_PUBLIC_PRIMITIVE_ATTRIBUTE", "URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"}, justification="Preserve API compatibility; read by Stapler")
    public boolean hasDownPage = false;
    @SuppressFBWarnings(value={"PA_PUBLIC_PRIMITIVE_ATTRIBUTE", "URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"}, justification="Preserve API compatibility; read by Stapler")
    public long nextBuildNumber;
    public HistoryWidget widget;
    @SuppressFBWarnings(value={"PA_PUBLIC_PRIMITIVE_ATTRIBUTE"}, justification="Preserve API compatibility")
    public long newestOnPage = Long.MIN_VALUE;
    @SuppressFBWarnings(value={"PA_PUBLIC_PRIMITIVE_ATTRIBUTE"}, justification="Preserve API compatibility")
    public long oldestOnPage = Long.MAX_VALUE;

    public HistoryPageFilter(int maxEntries) {
        this.maxEntries = maxEntries;
    }

    public void setNewerThan(Long newerThan) {
        if (this.olderThan != null) {
            throw new UnsupportedOperationException("Cannot set 'newerThan'. 'olderThan' already set.");
        }
        this.newerThan = newerThan;
    }

    public void setOlderThan(Long olderThan) {
        if (this.newerThan != null) {
            throw new UnsupportedOperationException("Cannot set 'olderThan'. 'newerThan' already set.");
        }
        this.olderThan = olderThan;
    }

    public void setSearchString(@NonNull String searchString) {
        this.searchString = searchString;
    }

    public void add(@NonNull Iterable<T> runItems) {
        this.addInternal(runItems);
    }

    public void add(@NonNull Iterable<T> runItems, @NonNull List<QueueItem> queueItems) {
        this.sort(queueItems);
        this.addInternal(Iterables.concat(queueItems, runItems));
    }

    private <ItemT> void addInternal(@NonNull Iterable<ItemT> items) {
        block10: {
            block12: {
                ItemT item;
                block11: {
                    if (!items.iterator().hasNext()) {
                        return;
                    }
                    this.nextBuildNumber = this.getNextBuildNumber(items.iterator().next());
                    if (this.newerThan != null || this.olderThan != null) break block11;
                    Iterator<ItemT> iter = items.iterator();
                    while (iter.hasNext()) {
                        this.add(iter.next());
                        if (!this.isFull()) continue;
                    }
                    this.hasDownPage = iter.hasNext();
                    break block10;
                }
                if (this.newerThan == null) break block12;
                int toFillCount = this.getFillCount();
                if (toFillCount <= 0) break block10;
                LinkedList<ItemT> itemsToAdd = new LinkedList<ItemT>();
                Iterator<ItemT> iter = items.iterator();
                while (iter.hasNext() && HistoryPageEntry.getEntryId(item = iter.next()) > this.newerThan) {
                    itemsToAdd.addLast(item);
                    if (itemsToAdd.size() <= toFillCount) continue;
                    itemsToAdd.removeFirst();
                    this.hasUpPage = true;
                }
                if (itemsToAdd.isEmpty()) {
                    this.hasDownPage = true;
                } else {
                    if (itemsToAdd.size() < toFillCount) {
                        Iterator<ItemT> skippedIter = items.iterator();
                        Iterators.skip(skippedIter, itemsToAdd.size());
                        for (int i = itemsToAdd.size(); i < toFillCount && skippedIter.hasNext(); ++i) {
                            ItemT item2 = skippedIter.next();
                            itemsToAdd.addLast(item2);
                        }
                    }
                    this.hasDownPage = iter.hasNext();
                    for (Object item3 : itemsToAdd) {
                        this.add(item3);
                    }
                }
                break block10;
            }
            Iterator<ItemT> iter = items.iterator();
            while (iter.hasNext()) {
                ItemT item = iter.next();
                if (HistoryPageEntry.getEntryId(item) >= this.olderThan) {
                    this.hasUpPage = true;
                    continue;
                }
                this.add(item);
                if (!this.isFull()) continue;
                this.hasDownPage = iter.hasNext();
                break;
            }
        }
    }

    public int size() {
        return this.queueItems.size() + this.runs.size();
    }

    private void sort(List<?> items) {
        items.sort(new Comparator<Object>(this){

            @Override
            public int compare(Object o1, Object o2) {
                long o1QID = HistoryPageEntry.getEntryId(o1);
                long o2QID = HistoryPageEntry.getEntryId(o2);
                return Long.compare(o2QID, o1QID);
            }
        });
    }

    private long getNextBuildNumber(@NonNull Object entry) {
        Object o;
        if (this.widget != null && (o = this.widget.owner) instanceof Job) {
            Job job = (Job)o;
            return job.getNextBuildNumber();
        }
        return HistoryPageEntry.getEntryId(entry) + 1L;
    }

    private void addQueueItem(QueueItem item) {
        HistoryPageEntry<QueueItem> entry = new HistoryPageEntry<QueueItem>(item);
        this.queueItems.add(entry);
        this.updateNewestOldest(entry.getEntryId());
    }

    private void addRun(HistoricalBuild run) {
        HistoryPageEntry<HistoricalBuild> entry = new HistoryPageEntry<HistoricalBuild>(run);
        if (!this.runs.isEmpty() && entry.getEntryId() > this.runs.get(this.runs.size() - 1).getEntryId()) {
            throw new IllegalStateException("Cannot add newer " + String.valueOf(run) + " to descending-order list " + String.valueOf(this.runs.stream().map(HistoryPageEntry::getEntry).collect(Collectors.toList())));
        }
        this.runs.add(entry);
        this.updateNewestOldest(entry.getEntryId());
    }

    private void updateNewestOldest(long entryId) {
        this.newestOnPage = Math.max(this.newestOnPage, entryId);
        this.oldestOnPage = Math.min(this.oldestOnPage, entryId);
    }

    private boolean add(Object entry) {
        if (entry instanceof QueueItem) {
            QueueItem item = (QueueItem)entry;
            if (this.searchString != null && !this.fitsSearchParams(item)) {
                return false;
            }
            this.addQueueItem(item);
            return true;
        }
        if (entry instanceof HistoricalBuild) {
            HistoricalBuild run = (HistoricalBuild)entry;
            if (this.searchString != null && !this.fitsSearchParams(run)) {
                return false;
            }
            this.addRun(run);
            return true;
        }
        return false;
    }

    private boolean isFull() {
        return this.size() >= this.maxEntries;
    }

    private int getFillCount() {
        return Math.max(0, this.maxEntries - this.size());
    }

    private boolean fitsSearchParams(@NonNull QueueItem item) {
        if (this.fitsSearchString(item.getDisplayName())) {
            return true;
        }
        return this.fitsSearchString(item.getId());
    }

    private boolean fitsSearchParams(@NonNull HistoricalBuild run) {
        if (this.searchString == null) {
            return true;
        }
        if (this.fitsSearchString(run.getDisplayName())) {
            return true;
        }
        if (this.fitsSearchString(run.getDescription())) {
            return true;
        }
        if (this.fitsSearchString(run.getNumber())) {
            return true;
        }
        if (this.fitsSearchString(run.getQueueId())) {
            return true;
        }
        if (this.fitsSearchString(run.getResult())) {
            return true;
        }
        if (run instanceof AbstractBuild && this.fitsSearchBuildVariables((AbstractBuild)run)) {
            return true;
        }
        List<ParameterValue> parameters = run.getParameterValues();
        return this.fitsSearchBuildParameters(parameters);
    }

    private boolean fitsSearchString(Object data) {
        if (this.searchString == null) {
            return true;
        }
        if (data == null) {
            return false;
        }
        if (data instanceof Number) {
            return data.toString().equals(this.searchString);
        }
        if (UserSearchProperty.isCaseInsensitive()) {
            return data.toString().toLowerCase().contains(this.searchString.toLowerCase());
        }
        return data.toString().contains(this.searchString);
    }

    private boolean fitsSearchBuildVariables(AbstractBuild<?, ?> runAsBuild) {
        Map<String, String> buildVariables = runAsBuild.getBuildVariables();
        Set<String> sensitiveBuildVariables = runAsBuild.getSensitiveBuildVariables();
        for (Map.Entry<String, String> param : buildVariables.entrySet()) {
            if (sensitiveBuildVariables.contains(param.getKey()) || !this.fitsSearchString(param.getValue())) continue;
            return true;
        }
        return false;
    }

    private boolean fitsSearchBuildParameters(List<ParameterValue> parameters) {
        for (ParameterValue parameter : parameters) {
            if (parameter.isSensitive() || !this.fitsSearchString(parameter.getValue())) continue;
            return true;
        }
        return false;
    }
}

