/*
 * Decompiled with CFR 0.152.
 */
package jenkins.model.queue;

import hudson.model.TaskListener;
import hudson.model.queue.CauseOfBlockage;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class CompositeCauseOfBlockage
extends CauseOfBlockage {
    public final Map<String, CauseOfBlockage> uniqueReasons = new TreeMap<String, CauseOfBlockage>();
    private static final int MAX_REASONS_TO_DISPLAY = 5;

    public CompositeCauseOfBlockage(List<CauseOfBlockage> delegates) {
        for (CauseOfBlockage delegate : delegates) {
            this.uniqueReasons.put(delegate.getShortDescription(), delegate);
        }
    }

    @Override
    public String getShortDescription() {
        int totalReasons = this.uniqueReasons.size();
        if (totalReasons <= 5) {
            return String.join((CharSequence)"; ", this.uniqueReasons.keySet());
        }
        String truncatedReasons = this.uniqueReasons.keySet().stream().limit(5L).collect(Collectors.joining("; "));
        int remaining = totalReasons - 5;
        return truncatedReasons + "; ... and " + remaining + " more";
    }

    @Override
    public void print(TaskListener listener) {
        for (CauseOfBlockage delegate : this.uniqueReasons.values()) {
            delegate.print(listener);
        }
    }
}

