/*
 * Decompiled with CFR 0.152.
 */
package hudson.views;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.DescriptorExtensionList;
import hudson.Extension;
import hudson.ExtensionPoint;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.View;
import hudson.views.DefaultViewsTabBar;
import hudson.views.ViewsTabBarDescriptor;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.StaplerRequest2;

public abstract class ViewsTabBar
implements Describable<ViewsTabBar>,
ExtensionPoint {
    public static DescriptorExtensionList<ViewsTabBar, Descriptor<ViewsTabBar>> all() {
        return Jenkins.get().getDescriptorList(ViewsTabBar.class);
    }

    public ViewsTabBarDescriptor getDescriptor() {
        return (ViewsTabBarDescriptor)Describable.super.getDescriptor();
    }

    @Restricted(value={NoExternalUse.class})
    @NonNull
    public List<View> sort(@NonNull List<? extends View> views) {
        ArrayList<View> result = new ArrayList<View>(views);
        result.sort(Comparator.comparing(View::getDisplayName));
        return result;
    }

    @Extension(ordinal=310.0)
    @Symbol(value={"viewsTabBar"})
    public static class GlobalConfigurationImpl
    extends GlobalConfiguration {
        public ViewsTabBar getViewsTabBar() {
            return Jenkins.get().getViewsTabBar();
        }

        @Override
        public boolean configure(StaplerRequest2 req, JSONObject json) throws Descriptor.FormException {
            Jenkins j = Jenkins.get();
            if (json.has("viewsTabBar")) {
                j.setViewsTabBar((ViewsTabBar)req.bindJSON(ViewsTabBar.class, json.getJSONObject("viewsTabBar")));
            } else {
                j.setViewsTabBar(new DefaultViewsTabBar());
            }
            return true;
        }
    }
}

