/*
 * Decompiled with CFR 0.152.
 */
package hudson.util;

import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.collections.MapConverter;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.mapper.Mapper;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public final class PackedMap<K, V>
extends AbstractMap<K, V> {
    private final Object[] kvpairs;
    private final Set<Map.Entry<K, V>> entrySet = new AbstractSet<Map.Entry<K, V>>(){

        @Override
        @NonNull
        public Iterator<Map.Entry<K, V>> iterator() {
            return new Iterator<Map.Entry<K, V>>(){
                int index = 0;

                @Override
                public boolean hasNext() {
                    return this.index < PackedMap.this.kvpairs.length;
                }

                @Override
                public Map.Entry<K, V> next() {
                    final Object k = PackedMap.this.kvpairs[this.index++];
                    final Object v = PackedMap.this.kvpairs[this.index++];
                    return new Map.Entry<K, V>(this){

                        @Override
                        public K getKey() {
                            return k;
                        }

                        @Override
                        public V getValue() {
                            return v;
                        }

                        @Override
                        public V setValue(V value) {
                            throw new UnsupportedOperationException();
                        }
                    };
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public int size() {
            return PackedMap.this.kvpairs.length / 2;
        }
    };

    public static <K, V> PackedMap<K, V> of(Map<? extends K, ? extends V> src) {
        return new PackedMap<K, V>(src);
    }

    private PackedMap(Map<? extends K, ? extends V> src) {
        this.kvpairs = new Object[src.size() * 2];
        int i = 0;
        for (Map.Entry<K, V> e : src.entrySet()) {
            this.kvpairs[i++] = e.getKey();
            this.kvpairs[i++] = e.getValue();
        }
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.entrySet;
    }

    @Override
    public boolean containsKey(Object key) {
        for (int i = 0; i < this.kvpairs.length; i += 2) {
            if (!key.equals(this.kvpairs[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(Object key) {
        for (int i = 0; i < this.kvpairs.length; i += 2) {
            if (!key.equals(this.kvpairs[i])) continue;
            return (V)this.kvpairs[i + 1];
        }
        return null;
    }

    @Override
    @NonNull
    public Collection<V> values() {
        return new AbstractList<V>(){

            @Override
            public V get(int index) {
                return PackedMap.this.kvpairs[index * 2];
            }

            @Override
            public int size() {
                return PackedMap.this.size();
            }
        };
    }

    public static class ConverterImpl
    extends MapConverter {
        public ConverterImpl(Mapper mapper) {
            super(mapper);
        }

        public boolean canConvert(Class type) {
            return type == PackedMap.class;
        }

        protected Object createCollection(Class type) {
            return new LinkedHashMap();
        }

        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            return PackedMap.of((Map)super.unmarshal(reader, context));
        }
    }
}

