/*
 * Decompiled with CFR 0.152.
 */
package hudson.model.labels;

import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.BulkChange;
import hudson.XmlFile;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.model.Failure;
import hudson.model.Label;
import hudson.model.Saveable;
import hudson.model.labels.LabelAtomProperty;
import hudson.model.labels.LabelAtomPropertyDescriptor;
import hudson.model.labels.LabelOperatorPrecedence;
import hudson.model.labels.LabelVisitor;
import hudson.model.listeners.SaveableListener;
import hudson.util.DescribableList;
import hudson.util.EditDistance;
import hudson.util.FormApply;
import hudson.util.QuotedStringTokenizer;
import hudson.util.VariableResolver;
import hudson.util.XStream2;
import jakarta.servlet.ServletException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import jenkins.model.Jenkins;
import jenkins.util.SystemProperties;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.interceptor.RequirePOST;
import org.kohsuke.stapler.verb.POST;

public class LabelAtom
extends Label
implements Saveable {
    private static final Pattern PROHIBITED_DOUBLE_DOT = Pattern.compile(".*\\.\\.[\\\\/].*");
    private static boolean ALLOW_FOLDER_TRAVERSAL = SystemProperties.getBoolean(LabelAtom.class.getName() + ".allowFolderTraversal");
    private DescribableList<LabelAtomProperty, LabelAtomPropertyDescriptor> properties = new DescribableList(this);
    protected volatile transient List<Action> transientActions = new Vector<Action>();
    private String description;
    private static final Logger LOGGER = Logger.getLogger(LabelAtom.class.getName());
    private static final XStream2 XSTREAM = new XStream2();

    public LabelAtom(@NonNull String name) {
        super(name);
    }

    @Override
    public String getExpression() {
        return LabelAtom.escape(this.name);
    }

    @Override
    public boolean isAtom() {
        return true;
    }

    @Override
    @NonNull
    public List<Action> getActions() {
        Vector<Action> actions = new Vector<Action>(super.getActions());
        actions.addAll(this.transientActions);
        return Collections.unmodifiableList(actions);
    }

    protected void updateTransientActions() {
        Vector<Action> ta = new Vector<Action>();
        for (LabelAtomProperty p : this.properties) {
            ta.addAll(p.getActions(this));
        }
        this.transientActions = ta;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) throws IOException {
        this.description = description;
        this.save();
    }

    public DescribableList<LabelAtomProperty, LabelAtomPropertyDescriptor> getProperties() {
        return this.properties;
    }

    @Exported
    public List<LabelAtomProperty> getPropertiesList() {
        return this.properties.toList();
    }

    @Override
    public boolean matches(VariableResolver<Boolean> resolver) {
        return resolver.resolve(this.name);
    }

    @Override
    public <V, P> V accept(LabelVisitor<V, P> visitor, P param) {
        return visitor.onAtom(this, param);
    }

    @Override
    public Set<LabelAtom> listAtoms() {
        return Set.of(this);
    }

    @Override
    public LabelOperatorPrecedence precedence() {
        return LabelOperatorPrecedence.ATOM;
    }

    XmlFile getConfigFile() {
        return new XmlFile(XSTREAM, new File(Jenkins.get().root, "labels/" + this.name + ".xml"));
    }

    @Override
    public void save() throws IOException {
        if (this.isInvalidName()) {
            throw new IOException("Invalid label");
        }
        if (BulkChange.contains(this)) {
            return;
        }
        try {
            this.getConfigFile().write(this);
            SaveableListener.fireOnChange(this, this.getConfigFile());
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to save " + String.valueOf(this.getConfigFile()), e);
        }
    }

    public void load() {
        XmlFile file = this.getConfigFile();
        if (file.exists()) {
            try {
                file.unmarshal(this);
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Failed to load " + String.valueOf(file), e);
            }
        }
        this.properties.setOwner(this);
        this.updateTransientActions();
    }

    public List<LabelAtomPropertyDescriptor> getApplicablePropertyDescriptors() {
        return LabelAtomProperty.all();
    }

    @POST
    public void doConfigSubmit(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException, Descriptor.FormException {
        Jenkins app = Jenkins.get();
        app.checkPermission(Jenkins.ADMINISTER);
        if (this.isInvalidName()) {
            throw new Descriptor.FormException("Invalid label", null);
        }
        this.properties.rebuild(req, req.getSubmittedForm(), this.getApplicablePropertyDescriptors());
        this.description = req.getSubmittedForm().getString("description");
        this.updateTransientActions();
        this.save();
        FormApply.success(".").generateResponse(req, rsp, null);
    }

    private boolean isInvalidName() {
        return !ALLOW_FOLDER_TRAVERSAL && PROHIBITED_DOUBLE_DOT.matcher(this.name).matches();
    }

    @RequirePOST
    @Restricted(value={DoNotUse.class})
    public synchronized void doSubmitDescription(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        this.setDescription(req.getParameter("description"));
        rsp.sendRedirect(".");
    }

    @Nullable
    public static LabelAtom get(@CheckForNull String l) {
        return Jenkins.get().getLabelAtom(l);
    }

    public static LabelAtom findNearest(String name) {
        ArrayList<String> candidates = new ArrayList<String>();
        for (LabelAtom a : Jenkins.get().getLabelAtoms()) {
            candidates.add(a.getName());
        }
        return LabelAtom.get(EditDistance.findNearest(name, candidates));
    }

    public static boolean needsEscape(String name) {
        try {
            Jenkins.checkGoodName(name);
            for (int i = 0; i < name.length(); ++i) {
                char ch = name.charAt(i);
                if (" ()\t\n".indexOf(ch) == -1) continue;
                return true;
            }
            return false;
        }
        catch (Failure failure) {
            return true;
        }
    }

    public static String escape(String name) {
        if (LabelAtom.needsEscape(name)) {
            return QuotedStringTokenizer.quote(name);
        }
        return name;
    }

    static {
        XSTREAM.registerConverter(new LabelAtomConverter(), 100);
    }

    private static class LabelAtomConverter
    extends XStream2.PassthruConverter<LabelAtom> {
        private Label.ConverterImpl leafLabelConverter = new Label.ConverterImpl();
        private static final Object IN_NESTED = "VisitingInnerLabelAtom";

        private LabelAtomConverter() {
            super(XSTREAM);
        }

        @Override
        public boolean canConvert(Class type) {
            return LabelAtom.class.isAssignableFrom(type);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
            if (context.get(IN_NESTED) == null) {
                context.put(IN_NESTED, (Object)true);
                try {
                    super.marshal(source, writer, context);
                }
                finally {
                    context.put(IN_NESTED, (Object)false);
                }
            } else {
                this.leafLabelConverter.marshal(source, writer, context);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            if (context.get(IN_NESTED) == null) {
                context.put(IN_NESTED, (Object)true);
                try {
                    Object object = super.unmarshal(reader, context);
                    return object;
                }
                finally {
                    context.put(IN_NESTED, (Object)false);
                }
            }
            return this.leafLabelConverter.unmarshal(reader, context);
        }

        @Override
        protected void callback(LabelAtom obj, UnmarshallingContext context) {
        }
    }
}

