/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.model.Resource;
import hudson.model.ResourceActivity;
import hudson.model.ResourceList;
import hudson.util.AdaptedIterator;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArraySet;
import jenkins.util.ThrowingCallable;
import jenkins.util.ThrowingRunnable;

public class ResourceController {
    private final Set<ResourceActivity> inProgress = new CopyOnWriteArraySet<ResourceActivity>();
    private final Collection<ResourceList> resourceView = new AbstractCollection<ResourceList>(){

        @Override
        public Iterator<ResourceList> iterator() {
            return new AdaptedIterator<ResourceActivity, ResourceList>(this, ResourceController.this.inProgress.iterator()){

                @Override
                protected ResourceList adapt(ResourceActivity item) {
                    return item.getResourceList();
                }
            };
        }

        @Override
        public int size() {
            return ResourceController.this.inProgress.size();
        }
    };
    private ResourceList inUse = ResourceList.EMPTY;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(@NonNull Runnable task, ResourceActivity activity) throws InterruptedException {
        ResourceList resources = activity.getResourceList();
        this._runWithLock(() -> {
            while (this.inUse.isCollidingWith(resources)) {
                this._await();
            }
            this.inProgress.add(activity);
            this.inUse = ResourceList.union(this.inUse, resources);
        });
        try {
            task.run();
        }
        finally {
            this._runWithLock(() -> {
                this.inProgress.remove(activity);
                this.inUse = ResourceList.union(this.resourceView);
                this._signalAll();
            });
        }
    }

    public boolean canRun(ResourceList resources) {
        return this._callWithLock(() -> !this.inUse.isCollidingWith(resources));
    }

    public Resource getMissingResource(ResourceList resources) {
        return this._callWithLock(() -> resources.getConflict(this.inUse));
    }

    public ResourceActivity getBlockingActivity(ResourceActivity activity) {
        ResourceList res = activity.getResourceList();
        for (ResourceActivity a : this.inProgress) {
            if (!res.isCollidingWith(a.getResourceList())) continue;
            return a;
        }
        return null;
    }

    @SuppressFBWarnings(value={"WA_NOT_IN_LOOP"}, justification="the caller does indeed call this method in a loop")
    protected void _await() throws InterruptedException {
        this.wait();
    }

    protected void _signalAll() {
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T extends Throwable> void _runWithLock(ThrowingRunnable<T> runnable) throws T {
        ResourceController resourceController = this;
        synchronized (resourceController) {
            runnable.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _withLock(Runnable runnable) {
        ResourceController resourceController = this;
        synchronized (resourceController) {
            runnable.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <V, T extends Throwable> V _callWithLock(ThrowingCallable<V, T> callable) throws T {
        ResourceController resourceController = this;
        synchronized (resourceController) {
            return callable.call();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <V> V _withLock(Callable<V> callable) throws Exception {
        ResourceController resourceController = this;
        synchronized (resourceController) {
            return callable.call();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <V, T extends Throwable> V _withLock(hudson.remoting.Callable<V, T> callable) throws T {
        ResourceController resourceController = this;
        synchronized (resourceController) {
            return callable.call();
        }
    }
}

