/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import hudson.EnvVars;
import hudson.model.AbstractBuild;
import hudson.model.ParameterValue;
import hudson.model.Run;
import hudson.util.VariableResolver;
import java.util.Locale;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.export.Exported;

public class BooleanParameterValue
extends ParameterValue {
    @Exported(visibility=4)
    public final boolean value;

    @DataBoundConstructor
    public BooleanParameterValue(String name, boolean value) {
        this(name, value, null);
    }

    public BooleanParameterValue(String name, boolean value, String description) {
        super(name, description);
        this.value = value;
    }

    @Override
    public Boolean getValue() {
        return this.value;
    }

    @Override
    public void buildEnvironment(Run<?, ?> build, EnvVars env) {
        env.put(this.name, Boolean.toString(this.value));
        env.put(this.name.toUpperCase(Locale.ENGLISH), Boolean.toString(this.value));
    }

    @Override
    public VariableResolver<String> createVariableResolver(AbstractBuild<?, ?> build) {
        return name -> this.name.equals(name) ? Boolean.toString(this.value) : null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BooleanParameterValue that = (BooleanParameterValue)o;
        return this.value == that.value;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.value ? 1 : 0);
        return result;
    }

    public String toString() {
        return "(BooleanParameterValue) " + this.getName() + "='" + this.value + "'";
    }

    @Override
    public String getShortDescription() {
        return this.name + "=" + this.value;
    }
}

