/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jelly.tags.define;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.beanutils.DynaClass;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.MissingAttributeException;
import org.apache.commons.jelly.Tag;
import org.apache.commons.jelly.XMLOutput;
import org.apache.commons.jelly.impl.Attribute;
import org.apache.commons.jelly.impl.DynamicDynaBeanTag;
import org.apache.commons.jelly.impl.TagFactory;
import org.apache.commons.jelly.tags.define.DefineTagSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;

public class DynaBeanTag
extends DefineTagSupport {
    private static final Log log = LogFactory.getLog(DynaBeanTag.class);
    private static final Map EMPTY_MAP = new HashMap();
    private String name;
    private DynaClass dynaClass;
    private String varAttribute = "var";
    private Map attributes;

    public void addAttribute(Attribute attribute) {
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        this.attributes.put(attribute.getName(), attribute);
    }

    public void doTag(XMLOutput output) throws MissingAttributeException, JellyTagException {
        this.invokeBody(output);
        if (this.name == null) {
            throw new MissingAttributeException("name");
        }
        if (this.dynaClass == null) {
            throw new MissingAttributeException("dynaClass");
        }
        final DynaClass theDynaClass = this.dynaClass;
        final Map beanAttributes = this.attributes != null ? this.attributes : EMPTY_MAP;
        TagFactory factory = new TagFactory(){

            public Tag createTag(String name, Attributes attributes) {
                return new DynamicDynaBeanTag(theDynaClass, beanAttributes, DynaBeanTag.this.varAttribute);
            }
        };
        this.getTagLibrary().registerBeanTag(this.name, factory);
        this.attributes = null;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setVarAttribute(String varAttribute) {
        this.varAttribute = varAttribute;
    }

    public DynaClass getDynaClass() {
        return this.dynaClass;
    }

    public void setDynaClass(DynaClass dynaClass) {
        this.dynaClass = dynaClass;
    }
}

