/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler.lang;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.kohsuke.stapler.ClassDescriptor;
import org.kohsuke.stapler.Function;
import org.kohsuke.stapler.MetaClassLoader;
import org.kohsuke.stapler.lang.FieldRef;
import org.kohsuke.stapler.lang.Klass;
import org.kohsuke.stapler.lang.MethodRef;

public abstract class KlassNavigator<C> {
    public static final KlassNavigator<Class> JAVA = new KlassNavigator<Class>(){

        @Override
        public URL getResource(Class clazz, String resourceName) {
            URL res;
            ClassLoader cl = clazz.getClassLoader();
            if (cl == null) {
                return null;
            }
            Object fullName = resourceName.startsWith("/") ? resourceName.substring(1) : clazz.getName().replace('.', '/').replace('$', '/') + "/" + resourceName;
            if (MetaClassLoader.debugLoader != null && (res = MetaClassLoader.debugLoader.loader.getResource((String)fullName)) != null) {
                return res;
            }
            return cl.getResource((String)fullName);
        }

        @Override
        public Klass<Class> getSuperClass(Class clazz) {
            return Klass.java(clazz.getSuperclass());
        }

        @Override
        public Iterable<Klass<?>> getAncestors(Class clazz) {
            ArrayList r = new ArrayList();
            while (clazz != null) {
                r.add(Klass.java(clazz));
                clazz = clazz.getSuperclass();
            }
            return r;
        }

        @Override
        public Class toJavaClass(Class clazz) {
            return clazz;
        }

        @Override
        public List<MethodRef> getDeclaredMethods(Class clazz) {
            final Method[] methods = clazz.getDeclaredMethods();
            return new AbstractList<MethodRef>(this){

                @Override
                public MethodRef get(int index) {
                    return MethodRef.wrap(methods[index]);
                }

                @Override
                public int size() {
                    return methods.length;
                }
            };
        }

        @Override
        public List<FieldRef> getDeclaredFields(Class clazz) {
            final Field[] fields = clazz.getDeclaredFields();
            return new AbstractList<FieldRef>(this){

                @Override
                public FieldRef get(int index) {
                    return FieldRef.wrap(fields[index]);
                }

                @Override
                public int size() {
                    return fields.length;
                }
            };
        }

        @Override
        public List<Function> getFunctions(Class clazz) {
            return new ClassDescriptor((Class)clazz, (Class[])new Class[0]).methods;
        }
    };

    public abstract URL getResource(C var1, String var2);

    public abstract Iterable<Klass<?>> getAncestors(C var1);

    public abstract Klass<?> getSuperClass(C var1);

    public abstract Class toJavaClass(C var1);

    public abstract List<MethodRef> getDeclaredMethods(C var1);

    @NonNull
    public List<FieldRef> getDeclaredFields(C clazz) {
        return Collections.emptyList();
    }

    @NonNull
    public List<Function> getFunctions(C clazz) {
        return Collections.emptyList();
    }

    public boolean isArray(C clazz) {
        Class j = this.toJavaClass(clazz);
        return j.isArray() || List.class.isAssignableFrom(j);
    }

    public Object getArrayElement(Object o, int index) throws IndexOutOfBoundsException {
        if (o instanceof List) {
            return ((List)o).get(index);
        }
        return Array.get(o, index);
    }

    public boolean isMap(C clazz) {
        return Map.class.isAssignableFrom(this.toJavaClass(clazz));
    }

    public Object getMapElement(Object o, String key) {
        return ((Map)o).get(key);
    }
}

