/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ezmorph.object;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Locale;
import java.util.Objects;
import net.sf.ezmorph.MorphException;
import net.sf.ezmorph.object.AbstractObjectMorpher;

public final class BigIntegerMorpher
extends AbstractObjectMorpher {
    private BigInteger defaultValue;

    public BigIntegerMorpher() {
    }

    public BigIntegerMorpher(BigInteger defaultValue) {
        super(true);
        this.defaultValue = defaultValue;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BigIntegerMorpher)) {
            return false;
        }
        BigIntegerMorpher other = (BigIntegerMorpher)obj;
        if (this.isUseDefault() && other.isUseDefault()) {
            return Objects.equals(this.getDefaultValue(), other.getDefaultValue());
        }
        return !this.isUseDefault() && !other.isUseDefault();
    }

    public BigInteger getDefaultValue() {
        return this.defaultValue;
    }

    public int hashCode() {
        if (this.isUseDefault()) {
            return Objects.hashCode(this.getDefaultValue());
        }
        return 17;
    }

    @Override
    public Object morph(Object value) {
        if (value instanceof BigInteger) {
            return value;
        }
        if (value == null) {
            if (this.isUseDefault()) {
                return this.defaultValue;
            }
            return null;
        }
        if (value instanceof Number) {
            if (value instanceof Float) {
                Float f = (Float)value;
                if (f.isInfinite() || f.isNaN()) {
                    throw new MorphException("BigInteger can not be infinite or NaN");
                }
            } else if (value instanceof Double) {
                Double d = (Double)value;
                if (d.isInfinite() || d.isNaN()) {
                    throw new MorphException("BigInteger can not be infinite or NaN");
                }
            } else if (value instanceof BigDecimal) {
                return ((BigDecimal)value).toBigInteger();
            }
            return BigInteger.valueOf(((Number)value).longValue());
        }
        try {
            String str = this.getIntegerValue(value);
            if (str.length() == 0 || str.equalsIgnoreCase("null")) {
                return null;
            }
            return new BigInteger(str);
        }
        catch (NumberFormatException nfe) {
            if (this.isUseDefault()) {
                return this.defaultValue;
            }
            throw new MorphException(nfe);
        }
    }

    @Override
    public Class morphsTo() {
        return BigInteger.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getIntegerValue(Object obj) {
        Locale defaultLocale = Locale.getDefault();
        String str = null;
        try {
            Locale.setDefault(Locale.US);
            str = String.valueOf(obj).trim();
        }
        finally {
            Locale.setDefault(defaultLocale);
        }
        int index = str.indexOf(".");
        if (index != -1) {
            str = str.substring(0, index);
        }
        return str;
    }
}

