/*
 * Decompiled with CFR 0.152.
 */
package winstone.cmdline;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import winstone.cmdline.CompressionScheme;
import winstone.realm.ArgumentsRealm;

public class Option<T> {
    public static final OFile WEBROOT = Option.file("webroot");
    public static final OFile WARFILE = Option.file("warfile");
    public static final OFile JAVA_HOME = Option.file("javaHome");
    public static final OFile CONFIG = Option.file("config");
    public static final OString PREFIX = Option.string("prefix", "");
    public static final OFile COMMON_LIB_FOLDER = Option.file("commonLibFolder");
    public static final OFile LOGFILE = Option.file("logfile");
    public static final OBoolean LOG_THROWING_LINE_NO = Option.bool("logThrowingLineNo", false);
    public static final OBoolean LOG_THROWING_THREAD = Option.bool("logThrowingThread", false);
    public static final OInt DEBUG = new ODebugInt("debug", 5);
    private static final OInt _PORT = Option.integer("Port");
    private static final OString _LISTEN_ADDRESS = Option.string("ListenAddress");
    private static final OString _UNIX_DOMAIN_PATH = Option.string("UnixDomainPath");
    private static final OInt _KEEP_ALIVE_TIMEOUT = Option.integer("KeepAliveTimeout", 30000);
    public static final OInt HTTP_PORT = Option.integer("http" + String.valueOf(_PORT), 8080);
    public static final OString HTTP_LISTEN_ADDRESS = Option.string("http" + String.valueOf(_LISTEN_ADDRESS));
    public static final OString HTTP_UNIX_DOMAIN_PATH = Option.string("http" + String.valueOf(_UNIX_DOMAIN_PATH));
    public static final OInt HTTP_KEEP_ALIVE_TIMEOUT = Option.integer("http" + String.valueOf(_KEEP_ALIVE_TIMEOUT), (Integer)Option._KEEP_ALIVE_TIMEOUT.defaultValue);
    public static final OInt HTTPS_PORT = Option.integer("https" + String.valueOf(_PORT), -1);
    public static final OString HTTPS_LISTEN_ADDRESS = Option.string("https" + String.valueOf(_LISTEN_ADDRESS));
    public static final OInt HTTPS_KEEP_ALIVE_TIMEOUT = Option.integer("https" + String.valueOf(_KEEP_ALIVE_TIMEOUT), (Integer)Option._KEEP_ALIVE_TIMEOUT.defaultValue);
    public static final OFile HTTPS_KEY_STORE = Option.file("httpsKeyStore");
    public static final OString HTTPS_KEY_STORE_PASSWORD = Option.string("httpsKeyStorePassword");
    public static final OString HTTPS_KEY_STORE_TYPE = Option.string("httpsKeyStoreType");
    public static final OString HTTPS_PRIVATE_KEY_PASSWORD = Option.string("httpsPrivateKeyPassword");
    public static final OString HTTPS_KEY_MANAGER_TYPE = Option.string("httpsKeyManagerType", "SunX509");
    public static final OString HTTPS_VERIFY_CLIENT = Option.string("httpsVerifyClient", "false");
    public static final OString HTTPS_CERTIFICATE_ALIAS = Option.string("httpsCertificateAlias");
    public static final OString HTTPS_EXCLUDE_PROTOCOLS = Option.string("excludeProtocols", "SSL, SSLv2, SSLv2Hello, SSLv3");
    public static final OString HTTPS_EXCLUDE_CIPHER_SUITES = Option.string("excludeCipherSuites");
    public static final OBoolean HTTPS_REDIRECT_HTTP = Option.bool("httpsRedirectHttp", false);
    public static final OBoolean HTTPS_SNI_HOST_CHECK = Option.bool("httpsSniHostCheck", false);
    public static final OBoolean HTTPS_SNI_REQUIRED = Option.bool("httpsSniRequired", false);
    public static final OString HTTP2_LISTEN_ADDRESS = Option.string("http2" + String.valueOf(_LISTEN_ADDRESS));
    public static final OInt HTTP2_PORT = Option.integer("http2" + String.valueOf(_PORT), -1);
    public static final OInt CONTROL_PORT = Option.integer("controlPort", -1);
    public static final OBoolean USE_JMX = Option.bool("useJmx", false);
    public static final OInt QTP_MAXTHREADS = Option.integer("qtpMaxThreadsCount", -1);
    public static final OInt JETTY_ACCEPTORS = Option.integer("jettyAcceptorsCount", -1);
    public static final OInt JETTY_SELECTORS = Option.integer("jettySelectorsCount", 0);
    public static final OCompression COMPRESSION = new OCompression("compression", CompressionScheme.GZIP);
    public static final OString MIME_TYPES = Option.string("mimeTypes");
    public static final OInt MAX_PARAM_COUNT = Option.integer("maxParamCount", 10000);
    public static final OBoolean USAGE = Option.bool("usage", false);
    public static final OInt SESSION_TIMEOUT = Option.integer("sessionTimeout", -1);
    public static final OInt SESSION_EVICTION = Option.integer("sessionEviction", 1800);
    public static final OInt REQUEST_HEADER_SIZE = Option.integer("requestHeaderSize", 8192);
    public static final OInt RESPONSE_HEADER_SIZE = Option.integer("responseHeaderSize", 32768);
    public static final OInt REQUEST_FORM_CONTENT_SIZE = Option.integer("requestFormContentSize", Integer.MAX_VALUE);
    public static final OBoolean HELP = Option.bool("help", false);
    public static final OClass REALM_CLASS_NAME = Option.clazz("realmClassName", ArgumentsRealm.class);
    public static final OString ARGUMENTS_REALM_PASSWORD = Option.string("argumentsRealm.passwd.");
    public static final OString ARGUMENTS_REALM_ROLES = Option.string("argumentsRealm.roles.");
    public static final OFile FILEREALM_CONFIGFILE = Option.file("fileRealm.configFile");
    public static final OClass ACCESS_LOGGER_CLASSNAME = Option.clazz("accessLoggerClassName", null);
    public static final OString SIMPLE_ACCESS_LOGGER_FORMAT = Option.string("simpleAccessLogger.format", "combined");
    public static final OString SIMPLE_ACCESS_LOGGER_FILE = Option.string("simpleAccessLogger.file", "logs/###host###/###webapp###_access.log");
    public final String name;
    public final Class<T> type;
    public final T defaultValue;

    public static List<Option<?>> all(Class<?> clazz) {
        ArrayList r = new ArrayList();
        for (Field f : clazz.getFields()) {
            if (!Modifier.isStatic(f.getModifiers()) || !Option.class.isAssignableFrom(f.getType())) continue;
            try {
                r.add((Option)f.get(null));
            }
            catch (IllegalAccessException e) {
                throw (Error)new IllegalAccessError().initCause(e);
            }
        }
        return r;
    }

    public Option(String name, Class<T> type, T defaultValue) {
        this.name = name;
        this.type = type;
        this.defaultValue = defaultValue;
    }

    public void remove(Map<String, String> args) {
        args.remove(this.name);
    }

    public void put(Map<String, String> args, String value) {
        args.put(this.name, value);
    }

    public boolean isIn(Map<String, String> args) {
        return args.containsKey(this.name);
    }

    public boolean isWildcard() {
        return this.name.endsWith(".");
    }

    public String toString() {
        return this.name;
    }

    public static OString string(String name) {
        return new OString(name, null);
    }

    public static OString string(String name, String defaultValue) {
        return new OString(name, defaultValue);
    }

    public static OBoolean bool(String name, boolean defaultValue) {
        return new OBoolean(name, defaultValue);
    }

    public static OFile file(String name) {
        return new OFile(name);
    }

    public static OClass clazz(String name, Class defaultValue) {
        return new OClass(name, defaultValue);
    }

    public static OInt integer(String name) {
        return new OInt(name, -1);
    }

    public static OInt integer(String name, int defaultValue) {
        return new OInt(name, defaultValue);
    }

    public static boolean booleanArg(Map<String, String> args, String name, boolean defaultTrue) {
        String value = args.get(name);
        if (defaultTrue) {
            return value == null || value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes");
        }
        return value != null && (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes"));
    }

    public static String stringArg(Map<String, String> args, String name, String defaultValue) {
        return args.get(name) == null ? defaultValue : args.get(name);
    }

    public static int intArg(Map<String, String> args, String name, int defaultValue) {
        return Integer.parseInt(Option.stringArg(args, name, "" + defaultValue));
    }

    public static class OString
    extends Option<String> {
        public OString(String name, String defaultValue) {
            super(name, String.class, defaultValue);
        }

        public String get(Map<String, String> args) {
            return this.get(args, (String)this.defaultValue);
        }

        public char[] getCharArray(Map<String, String> args) {
            String v = this.get(args);
            return v != null ? v.toCharArray() : null;
        }

        public String get(Map<String, String> args, String defaultValue) {
            String v = args.get(this.name);
            return v != null ? v : defaultValue;
        }
    }

    public static class OBoolean
    extends Option<Boolean> {
        public OBoolean(String name, boolean defaultValue) {
            super(name, Boolean.class, defaultValue);
        }

        public boolean get(Map<String, String> args) {
            return this.get(args, (Boolean)this.defaultValue);
        }

        public boolean get(Map<String, String> args, boolean defaultValue) {
            return OBoolean.booleanArg(args, this.name, defaultValue);
        }
    }

    public static class OFile
    extends Option<File> {
        public OFile(String name) {
            super(name, File.class, null);
        }

        @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="false positive, args come from command line")
        public File get(Map<String, String> args, File defaultValue) {
            String v = args.get(this.name);
            return v != null ? new File(v) : defaultValue;
        }

        public File get(Map<String, String> args) {
            return this.get(args, null);
        }
    }

    public static class OClass
    extends Option<Class> {
        public OClass(String name, Class defaultValue) {
            super(name, Class.class, defaultValue);
        }

        public <T> Class<? extends T> get(Map<String, String> args, Class<T> expectedType) throws ClassNotFoundException {
            return this.get(args, expectedType, this.getClass().getClassLoader());
        }

        public <T> Class<? extends T> get(Map<String, String> args, Class<T> expectedType, ClassLoader cl) throws ClassNotFoundException {
            String v = args.get(this.name);
            if (v == null) {
                return (Class)this.defaultValue;
            }
            if ((v = v.trim()).length() == 0) {
                return (Class)this.defaultValue;
            }
            Class<?> c = Class.forName(v, true, cl);
            if (!expectedType.isAssignableFrom(c)) {
                throw new ClassNotFoundException("Expected a subype of " + String.valueOf(expectedType) + " but got " + String.valueOf(c) + " instead");
            }
            return c.asSubclass(expectedType);
        }
    }

    public static class OInt
    extends Option<Integer> {
        public OInt(String name, int defaultValue) {
            super(name, Integer.class, defaultValue);
        }

        public int get(Map<String, String> args) {
            return OInt.intArg(args, this.name, (Integer)this.defaultValue);
        }

        public int get(Map<String, String> args, int defaultValue) {
            return OInt.intArg(args, this.name, defaultValue);
        }
    }

    public static class ODebugInt
    extends OInt {
        public ODebugInt(String name, int defaultValue) {
            super(name, defaultValue);
        }

        @Override
        public int get(Map<String, String> args) {
            switch (super.get(args)) {
                case 1: {
                    return Level.OFF.intValue();
                }
                case 2: {
                    return Level.SEVERE.intValue();
                }
                case 3: {
                    return Level.WARNING.intValue();
                }
                case 4: {
                    return Level.INFO.intValue();
                }
                case 6: {
                    return Level.FINE.intValue();
                }
                case 7: {
                    return Level.FINER.intValue();
                }
                case 8: {
                    return Level.FINEST.intValue();
                }
                case 9: {
                    return Level.ALL.intValue();
                }
            }
            return Level.INFO.intValue();
        }
    }

    public static class OCompression
    extends Option<CompressionScheme> {
        public OCompression(String name, CompressionScheme defaultValue) {
            super(name, CompressionScheme.class, defaultValue);
        }

        public CompressionScheme get(Map<String, String> args) {
            return this.get(args, (CompressionScheme)((Object)this.defaultValue));
        }

        public CompressionScheme get(Map<String, String> args, CompressionScheme defaultValue) {
            CompressionScheme compressionScheme;
            String v = args.get(this.name);
            if (v == null) {
                compressionScheme = defaultValue;
            } else if (v.equalsIgnoreCase("gzip")) {
                compressionScheme = CompressionScheme.GZIP;
            } else if (v.equalsIgnoreCase("none")) {
                compressionScheme = CompressionScheme.NONE;
            } else {
                throw new IllegalArgumentException("Unexpected compression scheme: " + v);
            }
            return compressionScheme;
        }
    }
}

