/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.parser;

import java.nio.ByteBuffer;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http2.ErrorCode;
import org.eclipse.jetty.http2.hpack.HpackDecoder;
import org.eclipse.jetty.http2.hpack.HpackException;
import org.eclipse.jetty.http2.parser.BodyParser;
import org.eclipse.jetty.http2.parser.HeaderParser;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.RetainableByteBuffer;
import org.eclipse.jetty.util.BufferUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeaderBlockParser {
    private static final Logger LOG = LoggerFactory.getLogger(HeaderBlockParser.class);
    private final HeaderParser headerParser;
    private final ByteBufferPool bufferPool;
    private final HpackDecoder hpackDecoder;
    private final BodyParser notifier;
    private RetainableByteBuffer blockBuffer;

    public HeaderBlockParser(HeaderParser headerParser, ByteBufferPool bufferPool, HpackDecoder hpackDecoder, BodyParser notifier) {
        this.headerParser = headerParser;
        this.bufferPool = bufferPool;
        this.hpackDecoder = hpackDecoder;
        this.notifier = notifier;
    }

    public int getMaxHeaderListSize() {
        return this.hpackDecoder.getMaxHeaderListSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetaData parse(ByteBuffer buffer, int blockLength) {
        ByteBuffer toDecode;
        ByteBuffer byteBuffer = this.blockBuffer == null ? null : this.blockBuffer.getByteBuffer();
        int accumulated = byteBuffer == null ? 0 : byteBuffer.position();
        int remaining = blockLength - accumulated;
        if (buffer.remaining() < remaining) {
            if (this.blockBuffer == null) {
                this.blockBuffer = this.bufferPool.acquire(blockLength, buffer.isDirect());
                byteBuffer = this.blockBuffer.getByteBuffer();
                BufferUtil.flipToFill(byteBuffer);
            }
            byteBuffer.put(buffer);
            return null;
        }
        int limit = buffer.limit();
        buffer.limit(buffer.position() + remaining);
        if (byteBuffer != null) {
            byteBuffer.put(buffer);
            BufferUtil.flipToFlush(byteBuffer, 0);
            toDecode = byteBuffer;
        } else {
            toDecode = buffer;
        }
        try {
            MetaData metaData = this.hpackDecoder.decode(toDecode);
            return metaData;
        }
        catch (HpackException.StreamException x) {
            if (LOG.isDebugEnabled()) {
                LOG.atDebug().setCause(x).log("Stream error, stream={}", (Object)this.headerParser.getStreamId());
            }
            if (x.isRequest()) {
                MetaData.Request request = MetaData.Failed.newFailedMetaDataRequest(HttpVersion.HTTP_2, x);
                return request;
            }
            if (x.isResponse()) {
                MetaData.Response response = MetaData.Failed.newFailedMetaDataResponse(HttpVersion.HTTP_2, x);
                return response;
            }
            MetaData metaData = MetaData.Failed.newFailedMetaData(HttpVersion.HTTP_2, x);
            return metaData;
        }
        catch (HpackException.CompressionException x) {
            if (LOG.isDebugEnabled()) {
                LOG.atDebug().setCause(x).log("Compression error, buffer={}", (Object)BufferUtil.toDetailString(buffer));
            }
            this.notifier.connectionFailure(buffer, ErrorCode.COMPRESSION_ERROR.code, "invalid_hpack_block");
            MetaData metaData = MetaData.Failed.newFailedMetaData(HttpVersion.HTTP_2, x);
            return metaData;
        }
        catch (HpackException.SessionException x) {
            if (LOG.isDebugEnabled()) {
                LOG.atDebug().setCause(x).log("Session error, buffer={}", (Object)BufferUtil.toDetailString(buffer));
            }
            this.notifier.connectionFailure(buffer, ErrorCode.PROTOCOL_ERROR.code, "invalid_hpack_block");
            MetaData metaData = MetaData.Failed.newFailedMetaData(HttpVersion.HTTP_2, x);
            return metaData;
        }
        finally {
            buffer.limit(limit);
            if (this.blockBuffer != null) {
                this.blockBuffer.release();
                this.blockBuffer = null;
            }
        }
    }
}

