/*
 * Decompiled with CFR 0.152.
 */
package jenkins.security.csp.impl;

import hudson.Extension;
import hudson.Util;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.security.csp.CspHeader;
import jenkins.security.csp.CspHeaderDecider;
import jenkins.util.SystemProperties;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
@Extension(ordinal=1.7976931348623157E308)
public class SystemPropertyHeaderDecider
implements CspHeaderDecider {
    private static final Logger LOGGER = Logger.getLogger(SystemPropertyHeaderDecider.class.getName());
    static final String SYSTEM_PROPERTY_NAME = CspHeader.class.getName() + ".headerName";

    @Override
    public Optional<CspHeader> decide() {
        String systemProperty = SystemProperties.getString(SYSTEM_PROPERTY_NAME);
        if (systemProperty != null) {
            LOGGER.log(Level.FINEST, "Using system property: {0}", new Object[]{systemProperty});
            String expected = Util.fixEmptyAndTrim(systemProperty);
            return Arrays.stream(CspHeader.values()).filter(h -> Objects.equals(expected, h.getHeaderName())).findFirst();
        }
        return Optional.empty();
    }

    public String getHeaderName() {
        Optional<CspHeader> decision = this.decide();
        return decision.map(CspHeader::getHeaderName).orElse(null);
    }
}

