/*
 * Decompiled with CFR 0.152.
 */
package jenkins.security.csp.impl;

import hudson.Extension;
import hudson.ExtensionList;
import hudson.model.AdministrativeMonitor;
import java.io.IOException;
import jenkins.security.csp.CspHeaderDecider;
import jenkins.security.csp.impl.CspConfiguration;
import jenkins.security.csp.impl.FallbackDecider;
import jenkins.security.csp.impl.Messages;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

@Restricted(value={NoExternalUse.class})
@Extension
public class CspRecommendation
extends AdministrativeMonitor {
    @Override
    public String getDisplayName() {
        return Messages.CspRecommendation_DisplayName();
    }

    @Override
    public boolean isActivated() {
        if (ExtensionList.lookupSingleton(CspConfiguration.class).enforce != null) {
            return false;
        }
        return CspHeaderDecider.getCurrentDecider().filter(d -> d instanceof FallbackDecider).isPresent();
    }

    @Override
    public boolean isSecurity() {
        return true;
    }

    @POST
    public void doAct(@QueryParameter String setup, @QueryParameter String more, @QueryParameter String dismiss, @QueryParameter String defer) throws IOException {
        if (more != null) {
            throw HttpResponses.redirectViaContextPath((String)"manage/administrativeMonitor/jenkins.security.csp.impl.CspRecommendation");
        }
        if (setup != null) {
            ExtensionList.lookupSingleton(CspConfiguration.class).enforce = false;
            throw HttpResponses.redirectViaContextPath((String)"manage/configureSecurity/#contentSecurityPolicy");
        }
        if (dismiss != null) {
            this.disable(true);
        }
        throw HttpResponses.redirectViaContextPath((String)"manage/");
    }
}

