/*
 * Decompiled with CFR 0.152.
 */
package hudson.util;

import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class HeadBufferingStream
extends FilterInputStream {
    private final ByteArrayOutputStream side;
    private final int sideBufferSize;

    public HeadBufferingStream(InputStream in, int sideBufferSize) {
        super(in);
        this.sideBufferSize = sideBufferSize;
        this.side = new ByteArrayOutputStream(sideBufferSize);
    }

    @Override
    public int read() throws IOException {
        int i = this.in.read();
        if (i >= 0 && this.space() > 0) {
            this.side.write(i);
        }
        return i;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int sp;
        int r = this.in.read(b, off, len);
        if (r > 0 && (sp = this.space()) > 0) {
            this.side.write(b, off, Math.min(r, sp));
        }
        return r;
    }

    private int space() {
        return this.sideBufferSize - this.side.size();
    }

    public void fillSide() throws IOException {
        byte[] buf = new byte[this.space()];
        while (this.space() > 0) {
            if (this.read(buf) >= 0) continue;
            return;
        }
    }

    public byte[] getSideBuffer() {
        return this.side.toByteArray();
    }
}

